<?php
/**
* @version $Id: $
* @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
* @subpackage Template for Paid Subscriptions
* @copyright (C) 2007-2020 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/
/** ensure this file is being included by a parent file */

use CBLib\Application\Application;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

$tmplVersion				=	1;	// This is the template version that needs to match
$cssClass					=	trim( $this->_model->cssclass );

if ( $cssClass ) {
	$cssClass				=	' ' . $cssClass;
}

$cssLocation				=	( Application::Cms()->getClientId() ? 'cbreg_admin_' : 'cbreg_' );

if ( strpos( $cssClass, $cssLocation . 'green' ) !== false ) {
	if ( strpos( $cssClass, 'bg-success' ) ===  false ) {
		$cssClass			.=	' bg-success';
	}

	if ( strpos( $cssClass, 'text-white' ) ===  false ) {
		$cssClass			.=	' text-white';
	}
} elseif ( strpos( $cssClass, $cssLocation . 'red' ) !== false ) {
	if ( strpos( $cssClass, 'bg-danger' ) === false ) {
		$cssClass			.=	' bg-danger';
	}

	if ( strpos( $cssClass, 'text-white' ) ===  false ) {
		$cssClass			.=	' text-white';
	}
} elseif ( strpos( $cssClass, $cssLocation . 'blue' ) !== false ) {
	if ( strpos( $cssClass, 'bg-primary' ) ===  false ) {
		$cssClass			.=	' bg-primary';
	}

	if ( strpos( $cssClass, 'text-white' ) ===  false ) {
		$cssClass			.=	' text-white';
	}
} elseif ( strpos( $cssClass, $cssLocation . 'cyan' ) !== false ) {
	if ( strpos( $cssClass, 'bg-info' ) ===  false ) {
		$cssClass			.=	' bg-info';
	}

	if ( strpos( $cssClass, 'text-white' ) ===  false ) {
		$cssClass			.=	' text-white';
	}
} elseif ( strpos( $cssClass, $cssLocation . 'yellow' ) !== false ) {
	if ( strpos( $cssClass, 'bg-warning' ) ===  false ) {
		$cssClass			.=	' bg-warning';
	}

	if ( strpos( $cssClass, 'text-white' ) ===  false ) {
		$cssClass			.=	' text-white';
	}
}
?>
<div class="mb-2 cbregPlan cbregPlan_default cbregPlanStatus cbregPlanStatus_default<?php echo $cssClass; ?>">
	<div class="form-check cbRegNameDesc">
		<div class="form-check-input mt-0 cbregTick">
			<?php echo $this->_icon; ?>
		</div>
		<div class="form-check-label mb-1 font-weight-bold cbregName">
			<?php echo $this->_model->get( 'name' ); ?>
		</div>
		<div class="cbregParagraph">
			<?php if ( $this->_model->get( 'description' ) != null ) { ?>
				<div class="cbregDescription">
					<?php echo $this->_model->get( 'description' ); ?>
				</div>
			<?php } ?>

			<?php if ( $this->_insertBeforeValidity ) { ?>
				<div class="cbregAfterSubDescription">
					<?php echo $this->_insertBeforeValidity; ?>
				</div>
			<?php } ?>

			<?php if ( $this->_model->get( 'validity' ) || $this->_model->get( 'stateText' ) ) { ?>
				<div class="cbregValExp">
					<?php if ( $this->_model->get( 'validity' ) ) { ?>
						<span class="cbregValidity">
							<?php echo $this->_model->get( 'validity' ); ?>
						</span>
					<?php } ?>

					<?php if ( $this->_model->get( 'stateText' ) ) { ?>
						<span class="cbregExpiring">
							<?php echo $this->_model->get( 'stateText' ); ?>
						</span>
					<?php } ?>
				</div>
			<?php } ?>

			<?php if ( $this->_insertAfterDescription ) { ?>
				<div class="mt-2 cbregSubPlanSelector">
					<?php echo $this->_insertAfterDescription; ?>
				</div>
			<?php } ?>
		</div>
	</div>
</div>

