<?php
/**
* @version $Id: $
* @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
* @subpackage Template for Paid Subscriptions
* @copyright (C) 2007-2020 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Application\Application;
use CBLib\Registry\GetterInterface;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/** @var cbpaidPaymentsListView $this */

global $_CB_framework;

$tmplVersion	=	1;	// This is the template version that needs to match
?>
<div class="cbsubsPaymentsHistory">
	<?php if ( $this->title ) { ?>
	<div class="mb-3 border-bottom cb-page-header cbsubsPaymentsHistoryHeader">
		<h3 class="m-0 p-0 mb-2 cb-page-header-title"><?php echo $this->title; ?></h3>
	</div>
	<?php } ?>
	<?php if ( $this->_model ) { ?>
	<div class="table-responsive cbsubsPaymentsHistoryList">
		<table class="m-0 table table-bordered cbsubsPaymentsHistoryListTable">
			<thead>
				<tr>
					<th scope="col" class="text-wrap cbsubsPaymentsHistoryItem">
						<?php echo CBPTXT::Th( 'Item' ); ?>
					</th>
					<th style="width: 20%" scope="col" class="text-wrap text-center cbsubsPaymentsHistoryAmount">
						<?php echo CBPTXT::Th( 'Amount' ); ?>
					</th>
					<th style="width: 20%" scope="col" class="text-wrap text-center cbsubsPaymentsHistoryState">
						<?php echo CBPTXT::Th( 'State' ); ?>
					</th>
					<th style="width: 20%" scope="col" class="text-wrap text-center cbsubsPaymentsHistoryDate">
						<?php echo CBPTXT::Th( 'Date' ); ?>
					</th>
				</tr>
			</thead>
			<tbody>
				<?php foreach ( $this->_model as /** @var cbpaidPayment $row */ $i => $row ) { ?>
				<tr>
					<td class="text-wrap cbsubsPaymentsHistoryItem">
						<?php echo $this->items[$row->id]; ?>
						<div class="text-small text-muted">
							<?php echo cbTooltip( null, CBPTXT::T( 'Transaction ID' ), null, null, null, htmlspecialchars( $row->get( 'txn_id', null, GetterInterface::STRING ) ), null, 'data-cbtooltip-simple="true"' ); ?>
						</div>
					</td>
					<td style="width: 20%" class="text-wrap text-center align-middle cbsubsPaymentsHistoryAmount">
						<?php echo $this->amounts[$row->id]; ?>
					</td>
					<td style="width: 20%" class="text-wrap text-center align-middle cbsubsPaymentsHistoryState">
						<?php if ( $row->get( 'payment_status', null, GetterInterface::STRING ) == 'Pending' ) { ?>
							<?php echo cbTooltip( null, sprintf( CBPTXT::T( 'waiting for %s' ), ( $row->get( 'pending_reason', null, GetterInterface::STRING ) ? htmlspecialchars( $row->get( 'pending_reason' ), null, GetterInterface::STRING ) : CBPTXT::T( 'Payment' ) ) ), null, null, null, htmlspecialchars( $row->get( 'payment_status', null, GetterInterface::STRING ) ), null, 'data-cbtooltip-simple="true"' ); ?>
						<?php } else { ?>
							<?php echo htmlspecialchars( $row->get( 'payment_status', null, GetterInterface::STRING ) ); ?>
						<?php } ?>
					</td>
					<td style="width: 20%" class="text-wrap text-center align-middle cbsubsPaymentsHistoryDate">
						<?php echo cbFormatDate( $row->get( 'time_paid', $row->get( 'time_created', null, GetterInterface::STRING ), GetterInterface::STRING ), true, true ); ?>
					</td>
				</tr>
				<?php } ?>
			</tbody>
		</table>
	</div>
	<?php } ?>
	<?php if ( $this->paging->total > $this->paging->limit ) { ?>
	<div class="mt-2 cbsubsPaymentsHistoryPaging">
		<?php echo $this->paging->getPagesLinks(); ?>
	</div>
	<?php } ?>
	<?php if ( ! Application::Cms()->getClientId() ) { ?>
	<div class="mt-2 cbControlButtonsLine cbsubsPaymentsHistoryBack">
		<a href="<?php echo $_CB_framework->userProfileUrl( $this->user->get( 'id', 0, GetterInterface::INT ), true, 'getcbpaidsubscriptionsTab' ); ?>">
			<?php echo CBPTXT::Th( 'Click here to go back to your user profile' ); ?>
		</a>
	</div>
	<?php } ?>
</div>