<?php
/**
* @version $Id: coupon.php 1465 2012-07-10 17:37:13Z beat $
* @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
* @subpackage Template for Paid Subscriptions
* @copyright (C) 2007-2020 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/
/** ensure this file is being included by a parent file */
if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

$tmplVersion	=	1;	// This is the template version that needs to match
?>

<div class="mb-2 cbregCoupon">
<?php if ( $this->couponsUsed && $this->couponRemoveButtonText ) {
	// Invisible first button as default to be posted when pressing enter (otherwise it sends first delete coupon button): For IE, it's not display:hidden style
?>
	<button type="submit" class="btn btn-light border" name="addcouponcode" value="1" style="position:absolute;left:-9999px;top:-9999px;height:0;width:0;">Add</button>
	<div class="mb-2 cbregCouponsInputed">
<?php 	foreach ( $this->couponsUsed as $coupon ) { ?>
		<div class="mb-2 input-group input-group-sm">
			<div class="w-sm-100 input-group-prepend">
				<div class="w-sm-100 bg-white input-group-text">
					<span class="cbregCouponCode"><?php echo $coupon->coupon_code; ?></span>
					<span class="cbregCouponCodeSAeparator pr-1">:</span>
					<span class="cbregCouponName"><?php echo $coupon->name; ?></span>
				</div>
			</div>
			<div class="w-sm-100 input-group-append">
				<button type="submit" class="w-sm-100 btn btn-sm btn-danger cbregCouponDelete" name="deletecouponcode[<?php echo $coupon->id;?>]" value="1"><?php echo CBPTXT::Th( $this->couponRemoveButtonText ); ?></button>
			</div>
		</div>
<?php	} ?>
	</div>
<?php } ?>
	<div class="mb-2 cbregCouponInput">
		<div class="mb-2 input-group">
			<div class="w-sm-100 input-group-prepend">
				<label for="cbsubscouponcode" class="m-0 w-sm-100 input-group-text"><?php echo CBPTXT::Th( $this->couponLabelText ); ?></label>
			</div>
			<input name="couponcode" id="cbsubscouponcode" type="text" class="w-sm-100 flex-grow-0 form-control" />
			<div class="w-sm-100 input-group-append">
				<button type="submit" class="btn btn-primary w-sm-100" name="addcouponcode" value="1"><?php echo CBPTXT::Th( $this->couponAddButtonText ); ?></button>
			</div>
		</div>
		<?php if ( $this->couponDescription ) { ?>
		<div class="mb-2 cbsubscouponInstructions"><?php echo CBPTXT::Th( $this->couponDescription ); ?></div>
		<?php } ?>
		<?php if ( count( $this->couponDescriptionHints ) > 0 ) { ?>
		<div class="mb-2 cbsubscouponsHints">
			<?php foreach ( $this->couponDescriptionHints as $htmlDescription ) { ?>
			<div class="mb-2 cbsubsCouponsHint">
				<?php echo $htmlDescription; ?>
			</div>
			<?php } ?>
		</div>
		<?php } ?>
	</div>
</div>
