<?php
/**
 * CBLib, Community Builder Library(TM)
 *
 * @version       $Id: 23.12.16 18:05 $
 * @package       ${NAMESPACE}
 * @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
 * @license       http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

use CBLib\Application\Application;
use CB\Database\Table\UserTable;

defined( 'CBLIB' ) or die();

/**
 * ${NAMESPACE}\cbpaidControllerInvoices Class implementation
 *
 */
class cbpaidControllerInvoices
{
	/**
	 * Generates the HTML to display the plans and upgrade possibilities for subscription tab/area
	 * (frontend and backend)
	 *
	 * @param  UserTable|null  $user  reflecting the user being displayed (here null)
	 * @return string|boolean         either string HTML for tab content, or false if ErrorMSG generated
	 */
	public static function showInvoicesList( $user )
	{
		$params				=	cbpaidApp::settingsParams();
		$showInvoices		=	$params->get( 'show_invoices', 1 );

		if ( ! $showInvoices ) {
			return false;
		}

		$invoicesShowPeriod	=	$params->get( 'invoices_show_period', '0000-06-00 00:00:00' );
		$itsmyself			=	$user === null || ( Application::MyUser()->getUserId() == $user->id );

		if ( ! ( $itsmyself || ( cbpaidApp::authoriseAction( 'cbsubs.sales' ) || cbpaidApp::authoriseAction( 'cbsubs.financial' ) ) ) ) {
			return false;
		}

		$subscriptionsGUI	=	new cbpaidControllerUI();

		$invoices			=	static::getInvoices( $user, $invoicesShowPeriod, false );

		if ( $invoicesShowPeriod && ( $invoicesShowPeriod != '0000-00-00 00:00:00' ) ) {
			$cbpaidTimes	=	cbpaidTimes::getInstance();
			$periodText		=	$cbpaidTimes->renderPeriod( $invoicesShowPeriod, 1, false );
		} else {
			$periodText		=	'';
		}

		return $subscriptionsGUI->showInvoicesList( $invoices, $user, $itsmyself, $periodText );
	}

	/**
	 * Gets invoices of $user for $invoicesShowPeriod, or just the count if $countOnly
	 *
	 * @param  UserTable                  $user
	 * @param  string                     $invoicesShowPeriod  SQL DATETIME formatted period of time
	 * @param  boolean                    $countOnly           Count only, do not get them
	 * @return cbpaidPaymentBasket[]|int
	 */
	public static function getInvoices( $user, $invoicesShowPeriod, $countOnly )
	{
		$basketsMgr				=	cbpaidOrdersMgr::getInstance();
		return $basketsMgr->getBaskets( $user, $invoicesShowPeriod, Application::Application()->getStartTime(), $countOnly );
	}
}
