<?php
/**
 * @package         Tabs & Accordions
 * @version         1.1.4
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            http://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

namespace RegularLabs\Plugin\System\TabsAccordions;

defined('_JEXEC') or die;

use RegularLabs\Library\Alias as RL_Alias;

class IDs
{
    private static array $ids = [];

    public static function create($item, $prefix = '')
    {
        $alias = RL_Alias::get($item->alias ?? $item->name);
        $alias = $alias ?: 'tab';

        $id = $prefix . $alias;

        $i = 1;
        while (in_array($id, self::$ids))
        {
            $id = $prefix . $alias . '-' . ++$i;
        }

        self::$ids[] = $id;

        return $id;
    }
}
