<?php
/**
 * @package         Snippets
 * @version         8.4.7
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            http://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory as JFactory;
use Joomla\CMS\Language\Text as JText;
use RegularLabs\Library\Document as RL_Document;
use RegularLabs\Library\Extension as RL_Extension;
use RegularLabs\Library\Html as RL_Html;
use RegularLabs\Library\Protect as RL_Protect;
use RegularLabs\Library\StringHelper as RL_String;
use RegularLabs\Library\SystemPlugin as RL_SystemPlugin;
use RegularLabs\Plugin\System\Snippets\Params;
use RegularLabs\Plugin\System\Snippets\Protect;
use RegularLabs\Plugin\System\Snippets\Replace;

// Do not run if component class is not found
if ( ! class_exists('RegularLabs\Component\Snippets\Administrator\Model\ItemsModel'))
{
    return;
}

// Do not instantiate plugin on install pages
// to prevent installation/update breaking because of potential breaking changes
$input = JFactory::getApplication()->input;
if (in_array($input->get('option', ''), ['com_installer', 'com_regularlabsmanager']) && $input->get('action', '') != '')
{
    return;
}

if ( ! is_file(JPATH_LIBRARIES . '/regularlabs/regularlabs.xml')
    || ! class_exists('RegularLabs\Library\Parameters')
    || ! class_exists('RegularLabs\Library\DownloadKey')
    || ! class_exists('RegularLabs\Library\SystemPlugin')
)
{
    JFactory::getLanguage()->load('plg_system_snippets', __DIR__);
    JFactory::getApplication()->enqueueMessage(
        JText::sprintf('SNP_EXTENSION_CAN_NOT_FUNCTION', JText::_('SNIPPETS'))
        . ' ' . JText::_('SNP_REGULAR_LABS_LIBRARY_NOT_INSTALLED'),
        'error'
    );

    return;
}

if ( ! RL_Document::isJoomlaVersion(4, 'SNIPPETS'))
{
    RL_Extension::disable('snippets', 'plugin');

    RL_Document::adminError(
        JText::sprintf('RL_PLUGIN_HAS_BEEN_DISABLED', JText::_('SNIPPETS'))
    );

    return;
}

if (true)
{
    class PlgSystemSnippets extends RL_SystemPlugin
    {
        public $_lang_prefix = 'SNP';
        public $_has_tags    = true;
        public $_jversion    = 4;

        public function extraChecks()
        {
            if ( ! is_file(JPATH_ADMINISTRATOR . '/components/com_snippets/snippets.xml'))
            {
                return false;
            }

            return parent::extraChecks();
        }

        public function processArticle(&$string, $area = 'article', $context = '', $article = null, $page = 0)
        {
            Replace::replaceTags($string, $area, $context, $article);
        }

        protected function changeDocumentBuffer(&$buffer)
        {
            return Replace::replaceTags($buffer, 'component');
        }

        protected function changeFinalHtmlOutput(&$html)
        {
            if ( ! RL_String::contains($html, Params::getTags(true)))
            {
                return false;
            }

            [$pre, $body, $post] = RL_Html::getBody($html);

            Replace::replaceTags($body, 'body');
            Replace::replaceTags($pre, 'head');

            $html = $pre . $body . $post;

            return true;
        }

        protected function cleanFinalHtmlOutput(&$html)
        {
            $params = Params::get();

            Protect::unprotectTags($html);

            RL_Protect::removeFromHtmlTagContent($html, Params::getTags(true));
            RL_Protect::removeInlineComments($html, 'Snippets');

            if ( ! $params->place_comments)
            {
                RL_Protect::removeCommentTags($html, 'Snippets');
            }
        }
    }
}
