<?php
/**
 * @package         Articles Anywhere
 * @version         13.1.3
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            http://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

namespace RegularLabs\Plugin\System\ArticlesAnywhere\Filters;

defined('_JEXEC') or die;

use RegularLabs\Plugin\System\ArticlesAnywhere\Helpers\CurrentArticle;
use RegularLabs\Plugin\System\ArticlesAnywhere\Helpers\Data as DataHelper;

class Filters
{
    private array  $filters = [];
    private        $params;
    private string $tag_type;

    /**
     * @param array  $filter_data
     * @param array  $params
     * @param string $tag_type 'article' or 'articles'
     */
    public function __construct($filter_data, $params = [], $tag_type = 'articles')
    {
        $this->params   = $params;
        $this->tag_type = $tag_type;

        if (empty($filter_data) && $this->isSingle())
        {
            $filter_data = [
                'id' => CurrentArticle::getId(),
            ];
        }

        $this->setFilters($filter_data);
    }

    protected function isSingle()
    {


        return true;
    }

    /**
     * @return Filter[]
     */
    public function get()
    {
        return $this->filters;
    }

    /**
     * @return array
     */
    public function getValueDataGroups()
    {
        $data_groups = [];

        foreach ($this->filters as $filter)
        {
            $data_groups = array_merge($data_groups, $filter->getValueDataGroups());
        }

        return $data_groups;
    }

    private function removeUnsupportedFilterKeys(&$data)
    {
        $data = array_intersect_key(
            (array) $data,
            [
                'article' => '',
                'title'   => '',
                'alias'   => '',
                'id'      => '',
            ]
        );
    }

    private function setFilters($data)
    {
        if (empty($data))
        {
            return;
        }

        $this->removeUnsupportedFilterKeys($data);

        foreach ($data as $key => $data_value)
        {
            $data_group = DataHelper::getDataGroup($key, $this->params);

            if ( ! $data_group)
            {
                continue;
            }

            $this->filters[] = new Filter($key, $data_value, $data_group);
        }
    }
}
