<?php
/**
 * @package         Snippets
 * @version         8.4.7
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            http://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

namespace RegularLabs\Plugin\EditorButton\Snippets;

defined('_JEXEC') or die;

use Joomla\CMS\Factory as JFactory;
use RegularLabs\Component\Snippets\Administrator\Model\ItemsModel as SNP_ItemsModel;
use RegularLabs\Library\EditorButtonPopup as RL_EditorButtonPopup;

class Popup extends RL_EditorButtonPopup
{
    protected $extension         = 'snippets';
    protected $require_core_auth = false;
    public    $items;
    public    $filterForm;
    public    $pagination;
    public    $state;

    public function init()
    {
        @define('JPATH_COMPONENT', JPATH_ADMINISTRATOR . '/components/com_snippets');
        @define('JPATH_COMPONENT_ADMINISTRATOR', JPATH_ADMINISTRATOR . '/components/com_snippets');

        $model = new SNP_ItemsModel;

        $limitstart = JFactory::getApplication()->input->getInt('limitstart', 0);

        $this->state = $model->getState();
        $model->setState('client_id', 0);

        if ($limitstart)
        {
            $model->setState('list.start', $limitstart);
        }

        $this->filterForm = $model->getFilterForm();
        $this->items      = $model->getItems(true);
        $this->pagination = $model->getPagination();
    }
}
