<?php
/**
 * @package         Snippets
 * @version         8.4.7
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            http://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

defined('_JEXEC') or die;

use Joomla\CMS\Filesystem\File as JFile;
use Joomla\CMS\Filesystem\Folder as JFolder;

class PlgEditorsXtdSnippetsInstallerScript
{
    public function postflight($install_type, $adapter)
    {
        if ( ! in_array($install_type, ['install', 'update']))
        {
            return true;
        }

        self::deleteJoomla3Files();

        return true;
    }

    private static function delete($files = [])
    {
        foreach ($files as $file)
        {
            if (is_dir($file))
            {
                JFolder::delete($file);
            }

            if (is_file($file))
            {
                JFile::delete($file);
            }
        }
    }

    private static function deleteJoomla3Files()
    {
        self::delete(
            [
                JPATH_SITE . '/media/snippets/css',
                JPATH_SITE . '/media/snippets/images',
                JPATH_SITE . '/media/snippets/less',
                JPATH_SITE . '/plugins/editors-xtd/snippets/layouts',
                JPATH_SITE . '/plugins/editors-xtd/snippets/fields.xml',
                JPATH_SITE . '/plugins/editors-xtd/snippets/helper.php',
                JPATH_SITE . '/plugins/editors-xtd/snippets/popup.php',
                JPATH_SITE . '/plugins/editors-xtd/snippets/popup.tmpl.php',
            ]
        );
    }
}
