<?php
/**
 * @package         Snippets
 * @version         8.4.7
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            http://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

use RegularLabs\Library\ActionLogPlugin as RL_ActionLogPlugin;
use RegularLabs\Library\Document as RL_Document;
use RegularLabs\Library\Extension as RL_Extension;

defined('_JEXEC') or die;

if ( ! is_file(JPATH_LIBRARIES . '/regularlabs/regularlabs.xml')
    || ! class_exists('RegularLabs\Library\Parameters')
    || ! class_exists('RegularLabs\Library\DownloadKey')
    || ! class_exists('RegularLabs\Library\ActionLogPlugin')
)
{
    return;
}

if ( ! RL_Document::isJoomlaVersion(4))
{
    RL_Extension::disable('snippets', 'plugin', 'actionlog');

    return;
}

if (true)
{
    class PlgActionlogSnippets extends RL_ActionLogPlugin
    {
        public $name  = 'SNIPPETS';
        public $alias = 'snippets';

        public function __construct(&$subject, array $config = [])
        {
            parent::__construct($subject, $config);

            $this->addItem('com_snippets', 'item', 'SNP_ITEM');
        }
    }
}
