<?php
/**
* Joomla Community Builder Paid Subscriptions Plugin: plug_cbsubsimage
* @version $Id: cbsubs.planimage.php 1516 2012-09-29 21:31:43Z beat $
* @package plug_cbsubsimage
* @subpackage cbsubs.image.php
* @author Beat
* @copyright (C) 2007-2022 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license Proprietary
*/

use CB\Database\Table\FieldTable;
use CB\Database\Table\UserTable;
use CBLib\Application\Application;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_PLUGINS;
$_PLUGINS->registerUserFieldTypes( array( 'planimage' => 'CBField_planimage' ) );
$_PLUGINS->registerUserFieldParams();

class CBField_planimage extends cbFieldHandler {
	
	/**
	 * Returns a field in specified format
	 *
	 * @param  FieldTable  $field
	 * @param  UserTable   $user
	 * @param  string      $output  'html', 'xml', 'json', 'php', 'csvheader', 'csv', 'rss', 'fieldslist', 'htmledit'
	 * @param  string      $reason  'profile' for user profile view, 'edit' for profile edit, 'register' for registration, 'list' for user-lists
	 * @param  int         $list_compare_types   IF reason == 'search' : 0 : simple 'is' search, 1 : advanced search with modes, 2 : simple 'any' search
	 * @return mixed                
	 */
	function getField( &$field, &$user, $output, $reason, $list_compare_types ) {
		$return		=	$this->plan_image( $output, $field, $user );

		switch ( $output ) {
			case 'html':
			case 'rss':
			case 'htmledit':
				if ( $reason == 'search' ) {
					return	null;
				} else {
					return $this->formatFieldValueLayout( $this->_formatFieldOutput( $field->get( 'name' ), $return, $output, false ), $reason, $field, $user );
				}
				break;
			default:
				return $this->_formatFieldOutput( $field->get( 'name' ), $return, $output, false );
				break;
		}
	}

	/**
	 * Returns image associated with active plan
	 *
	 * @param string     $output
	 * @param FieldTable $field
	 * @param UserTable  $user
	 * @return mixed
	 */
	function plan_image( $output, $field, $user ) {
		global $_CB_framework;

		$live_site								=	$_CB_framework->getCfg( 'live_site' );
		$absolute_path							=	$_CB_framework->getCfg( 'absolute_path' );
		$plans									=	$field->params->get( 'planimage_plans', null );
		$height									=	$field->params->get( 'planimage_height', 60 );
		$width									=	$field->params->get( 'planimage_width', 60 );
		$border									=	$field->params->get( 'planimage_border', 0 );
		$link									=	$field->params->get( 'planimage_link', 0 );
		$visibility								=	$field->params->get( 'planimage_visibility', 0 );
		$msg									=	$field->params->get( 'planimage_msg', null );
		$usrs									=	$field->params->get( 'planimage_usrs', null );
		$style									=	$field->params->get( 'planimage_display_style', 0 );
		$class									=	$field->params->get( 'planimage_display_class', null );
		$cbUser									=	CBuser::getInstance( $user->id );
		$myId									=	Application::MyUser()->getUserId();
		$isMod									=	Application::MyUser()->isGlobalModerator();
		$class									=	( $class ? ' class="' . $class . '"' : null );
		$usrs									=	explode( ',', $usrs );
		$hasAccess								=	array();
		$return									=	null;

		if ( $usrs ) foreach( $usrs as $usr ) {
			$hasAccess[]						=	$usr;
		}

		$visible								=	( ( $visibility == 0 ) || ( ( $visibility == 1 ) && ( $myId == $user->id ) ) || ( ( $visibility == 2 ) && ( $myId > 0 ) ) || ( ( $visibility == 3 ) && $isMod ) || ( ( $visibility == 4 ) && ( in_array( $myId, $hasAccess ) ) ) );
		$plans									=	explode( '|*|', $plans );

		if ( ! in_array( $output, array( 'html', 'rss', 'htmledit' ) ) ) {
			$return								=	array();

			if ( $plans && $visible ) {
				foreach( $plans as $plan ) {
					$img						=	$this->hasActivePlan( $user->id, $plan );

					if ( $img && file_exists( $absolute_path . $img ) ) {
						if ( in_array( $live_site . $img, $return ) ) {
							continue;
						}

						$return[]				=	$live_site . $img;
					}
				}
			}

			return $this->_implodeCBvalues( $return );
		}

		if ( $plans && $visible) {
			$exists								=	array();
			$return								.=	( ( $style == 2 ) ? '<ul' . $class . '>' : ( ( $style == 3 ) ? '<ol' . $class . '>' : null ) );
			
			foreach( $plans as $plan ) {
				$img							=	$this->hasActivePlan( $user->id, $plan );

				if ( $img && file_exists( $absolute_path . $img ) ) {
					if ( in_array( $img, $exists ) ) {
						continue;
					}

					$displayPlanUrlHtmlspecial	=	$_CB_framework->pluginClassUrl( array( 'plugin' => 'cbpaidsubscriptions', 'do' => 'displayplans', 'plans' => (int) $plan ), true );

					$return						.=	( ( $style == 0 ) ? '<span' . $class . '>' : ( ( $style == 1 ) ? '<div' . $class . '>' : ( ( $style == 2 ) || ( $style == 3 ) ? '<li>' : null ) ) )
												.		( $link ? '<a href="' . $displayPlanUrlHtmlspecial . '">' : null )
												.			'<img ' . ( $height ? 'height="' . $height . '"' : null ) . ' ' . ( $width ? 'width="' . $width . '"' : null ) . ' ' . ( $border ? 'style="border-width:' . $border . 'px;"' : null ) . ' src="' . htmlspecialchars( $live_site . $img ) . '" />'
												.		( $link ? '</a>' : null )
												.	( ( $style == 0 ) ? '</span>' : ( ( $style == 1 ) ? '</div>' : ( ( $style == 2 ) || ( $style == 3 ) ? '</li>' : null ) ) );

					$exists[]					=	$img;
				}
			}
			
			$return								.=	( ( $style == 2 ) ? '</ul>' : ( ( $style == 3 ) ? '</ol>' : null ) );
		} elseif ( ! $visible ) {
			$return								.=	$cbUser->replaceUserVars( $msg );
		}
		
		return $return;
	}
	
	/**
	 * Returns image path for active plan
	 *
	 * @param int     $userId
	 * @param int     $planId
	 * @return string
	 */
	function hasActivePlan( $userId, $planId ) {
		static $plans							=	array();

		if (  ! isset( $plans[$userId] ) ) {
			$plans[$userId]						=	array();
			// $paidUserExtension				=	cbpaidUserExtension::getInstance( $userId );
			// $subs							=	$paidUserExtension->getActiveSubscriptions();
			$user								=	CBuser::getUserDataInstance( $userId );
			$subsByPlanType						=	cbpaidSomethingMgr::getAllSomethingOfUser( $user );
			foreach ( $subsByPlanType as $subs ) {

				/** @var cbpaidSomething[] $subs */
				foreach ( array_keys( $subs ) as $k ) {
					$plan						=	$subs[$k]->getPlan();
					$plan_id					=	$plan->get( 'id' );
					$image						=	$plan->getParam( 'planimage_image', null, 'integrations' );

					if ( ! $image ) {
						continue;
					}

					$imagePath					=	$plan->getParam( 'planimage_image_path', null, 'integrations' );

					if ( ! $imagePath ) {
						$imagePath				=	'/images/stories';
					}

					$plans[$userId][$plan_id]	=	$imagePath . '/' . $image;
				}
			}
		}
		
		if ( isset( $plans[$userId][$planId] ) ) {
			return $plans[$userId][$planId];
		} else {
			return null;
		}
	}	
}
