<?php
/**
* Joomla Community Builder Paid Subscriptions Plugin: plug_cbsubsfolderaccess
* @version $Id: cbsubs.folderaccess.php 2424 2012-04-23 19:35:54Z kyle $
* @package plug_cbsubsfolderaccess
* @subpackage cbsubs.folderaccess.php
* @author Beat
* @copyright (C) Lightning MultiCom SA
* @license Proprietary
*/

use CB\Database\Table\UserTable;
use CBLib\Registry\ParamsInterface;
use CBLib\Language\CBTxt;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_PLUGINS;
$_PLUGINS->registerFunction( 'onCPayUserStateChange', 'onCPayUserStateChange', 'getcbsubsfolderaccessTab' );
$_PLUGINS->registerFunction( 'onBeforeLogin', 'onBeforeLogin', 'getcbsubsfolderaccessTab' );
$_PLUGINS->registerFunction( 'onAfterLogin', 'onAfterLogin', 'getcbsubsfolderaccessTab' );
$_PLUGINS->registerFunction( 'onAfterUserUpdate', 'onAfterUserUpdate', 'getcbsubsfolderaccessTab' );
$_PLUGINS->registerFunction( 'onAfterUpdateUser', 'onAfterUserUpdate', 'getcbsubsfolderaccessTab' );
$_PLUGINS->registerFunction( 'onAfterUserRegistration', 'onAfterUserRegistration', 'getcbsubsfolderaccessTab' );
$_PLUGINS->registerFunction( 'onAfterNewUser', 'onAfterUserRegistration', 'getcbsubsfolderaccessTab' );

class UserTableWithCBFolderAccess extends UserTable
{
	/** @var string  */
	public $_folderaccess	=	null;
}

class getcbsubsfolderaccessTab extends cbTabHandler {
	/** @var string  */
	public $password	=	null;

	/**
	 * Sync user on registration
	 *
	 * @param  UserTableWithCBFolderAccess  $user
	 */
	function onAfterUserRegistration( &$user ) {
		if ( $user->password != '' ) {
			$this->password			=	$this->encryptPassword( $user->password );
			$user->_folderaccess	=	$this->password;

			$this->_syncUser( $user );
		}
	}

	/**
	 * Store user password on login
	 *
	 * @param  string  $username
	 * @param  string  $password
	 * @return void
	 */
	function onBeforeLogin( /** @noinspection PhpUnusedParameterInspection */ &$username, &$password ) {
		if ( $password != '' ) {
			$this->password	=	$this->encryptPassword( $password );
		}
	}

	/**
	 * Sync user on login
	 *
	 * @param  UserTableWithCBFolderAccess  $user
	 */
	function onAfterLogin( &$user ) {
		if ( $this->password != '' ) {
			$user->_folderaccess	=	$this->password;

			$this->_syncUser( $user );
		}
	}

	/**
	 * Sync user on profile update
	 *
	 * @param  UserTableWithCBFolderAccess  $user
	 */
	function onAfterUserUpdate( &$user ) {
		if ( $user->password != '' ) {
			$this->password			=	$this->encryptPassword( $user->password );
			$user->_folderaccess	=	$this->password;

			$this->_syncUser( $user );
		}
	}

	/**
	 * encrypts password for htpasswd safe usage
	 *
	 * @param string $password
	 * @return string
	 *
	 * @throws UnexpectedValueException
	 */
	function encryptPassword( $password ) {
		if ( strtoupper( substr( PHP_OS, 0, 3 ) ) == 'WIN' ) {
			$method			=	'none';
		} else {
			$method			=	'sha1';
		}

		if ( class_exists( 'cbpaidApp' ) ) {
			$params			=	cbpaidApp::settingsParams();
			$encrypt		=	$params->get( 'folderaccess_method' );

			if ( $encrypt ) {
				$method		=	$encrypt;
			}
		}

		switch ( $method ) {
			case 'none':
				$encrypted	=	$password;
				break;
			case 'crypt':
				$encrypted	=	password_hash( $password,  PASSWORD_DEFAULT );
				break;
			case 'sha1':
				$encrypted	=	'{SHA}' . base64_encode( sha1( $password, true ) ) ;
				break;
			case 'md5':
				$encrypted	=	$this->cb_apr1_md5( $password );
				break;
			default:
				throw new UnexpectedValueException( 'Hashing method not set in CBSubs FolderAccess' );
		}

		return $encrypted;
	}

	/**
	 * apache md5 encryption method
	 *
	 * @param string $password
	 * @return string
	 */
	function cb_apr1_md5( $password ) {
		$salt			=	substr( str_shuffle( "abcdefghijklmnopqrstuvwxyz0123456789" ), 0, 8 );
		$len			=	strlen( $password );
		$text			=	( $password . '$apr1$' . $salt );
		$bin			=	pack( 'H32', md5( ( $password . $salt. $password ) ) );

		for( $i = $len; $i > 0; $i -= 16 ) {
			$text		.=	substr( $bin, 0, min( 16, $i ) );
		}

		for( $i = $len; $i > 0; $i >>= 1 ) {
			$text		.=	( ( $i & 1 ) ? chr(0) : $password[0] );
		}

		$bin			=	pack( 'H32', md5( $text ) );

		for($i = 0; $i < 1000; $i++) {
			$new		=	( ( $i & 1 ) ? $password : $bin );

			if ( $i % 3 ) {
				$new	.=	$salt;
			}

			if ( $i % 7 ) {
				$new	.=	$password;
			}

			$new		.=	( ( $i & 1 ) ? $bin : $password );
			$bin		=	pack( 'H32', md5( $new ) );
		}

		$tmp			=	null;

		for ( $i = 0; $i < 5; $i++ ) {
			$k			=	( $i + 6 );
			$j			=	( $i + 12 );

			if ( $j == 16 ) {
				$j		=	5;
			}

			$tmp		=	( $bin[$i] . $bin[$k] . $bin[$j] . $tmp );
		}

		$tmp			=	( chr( 0 ) . chr( 0 ) . $bin[11] . $tmp );
		$tmp			=	strtr( strrev( substr( base64_encode( $tmp ), 2 ) ), "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/", "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz" );

		return ( '$apr1$' . $salt . '$' . $tmp );
	}

	/**
	 * Syncs user to database and password file if password is changed
	 *
	 * @param  UserTableWithCBFolderAccess  $user
	 */
	function _syncUser( $user ) {
		$password											=	( $user->_folderaccess ? $user->_folderaccess : $this->password );

		if ( class_exists( 'cbpaidUserExtension' ) ) { // This is to avoid crashing site if cbsubs is disabled but not this plugin.
			$paidUserExtension								=	cbpaidUserExtension::getInstance( $user->id );
			$plans											=	$paidUserExtension->getActiveSubscriptions();

			if ( $plans ) foreach ( array_keys( $plans ) as $k ) {
				$plan										=	$plans[$k]->getPlan();

				for ( $i = 1; $i <= 5; $i++ ) {
					$path									=	$plan->getParam( 'folderaccess_path' . $i, null, 'integrations' );
					$type									=	(int) $plan->getParam( 'folderaccess_type' . $i, 0, 'integrations' );
					$msg									=	$plan->getParam( 'folderaccess_msg', null, 'integrations' );
					$index									=	(int) $plan->getParam( 'folderaccess_index' . $i, 1, 'integrations' );

					if ( $path != null ) {
						$access								=	$this->getFiles( $msg, $type, $path, $index );

						if ( ! $password ) {
							// No password supplied but we still want to be sure the htaccess files get created so exit here:
							continue;
						}

						if ( $access->htpasswd && file_exists( $access->htpasswd ) ) {
							$file_ht						=	fopen( $access->htpasswd, 'r' );

							if ( $file_ht ) {
								$content_size				=	filesize( $access->htpasswd );

								if ( $content_size ) {
									$content_file			=	fread( $file_ht, $content_size );
								} else {
									$content_file			=	'';
								}

								fclose( $file_ht );

								$foundUser					=	false;
								$newContents				=	$content_file;
								$users						=	explode( $this->_NL(), $content_file );

								for ( $u = 0; $u < count( $users ); $u++ ) {
									$userNamePsw			=	explode( ':', $users[$u] );

									if ( $userNamePsw[0] == $user->username ) {
										$foundUser			=	true;
										$newContents		=	preg_replace( '#(?<=^|\s)' . preg_quote( $users[$u], '#' ) . '(?=$|\s)#', $this->preg_replacement_quote( $user->username . ':' . $password ), $content_file );
									}
								}

								if ( $newContents && ( $content_file != $newContents ) ) {
									$file_ht				=	fopen( $access->htpasswd, 'w+' );

									fwrite( $file_ht, $newContents );
									fclose( $file_ht );
								} elseif ( ! $foundUser ) {
									$this->_addAccess( $user, $access->htpasswd );
								}
							}
						}

						if ( $access->htpasswd && ( ! file_exists( $access->htpasswd ) ) ) {
							$this->_addAccess( $user, $access->htpasswd );
						}
					}
				}
			}
		}
	}

	/**
	 * quotes the replacement string to clean backreferences
	 * (it is the missing preg_quote() for the replacement string).
	 *
	 * @param  string  $str
	 * @return string
	 */
	protected function preg_replacement_quote( $str )
	{
		return preg_replace('/(\$|\\\\)(?=\d)/', '\\\\\1', $str);
	}

	/**
	 * Sets file paths followed by checking and creating files if necessary
	 *
	 * @param string $msg
	 * @param int    $type
	 * @param string $path
	 * @param bool   $index
	 * @return object
	 */
	function getFiles( $msg, $type, $path, $index = true ) {
		global $_CB_framework;

		$access							=	new stdClass();

		if ( $path ) {
			if ( $type == 0 ) {
				$filePath				=	str_replace( '\\', '/', $_CB_framework->getCfg( 'absolute_path' ) . $path . '/' );
			} else {
				$filePath				=	str_replace( '\\', '/', $path . '/' );
			}

			$access->htaccess			=	$filePath . '.htaccess';
			$access->htpasswd			=	$filePath . '.htpasswd';

			if ( ! file_exists( $access->htaccess ) ) {
				$htaccessContent		=	'AuthType Basic' . $this->_NL()
										.	'AuthName "' . addslashes( CBTxt::T( $msg ) ) . '"' . $this->_NL()
										.	'AuthUserFile "' . addslashes( $access->htpasswd ) . '"' . $this->_NL()
										.	'require valid-user' . $this->_NL()
										.	'ErrorDocument 401 "' . addslashes( CBTxt::T( 'Authorization Required' ) ) . '"' . $this->_NL();

				if ( $index ) {
					$htaccessContent	.=	'Options +Indexes' . $this->_NL()
										.	'IndexOptions +FancyIndexing' . $this->_NL()
										.	'IndexOptions +FoldersFirst' . $this->_NL()
										.	'IndexIgnoreReset On' . $this->_NL()
										.	'IndexIgnore ..';
				} else {
					$htaccessContent	.=	'Options -Indexes' . $this->_NL()
										.	'IndexIgnore *';
				}

				$htaccessFile			=	fopen( $access->htaccess, 'w' );

				if ( $htaccessFile ) {
					fwrite( $htaccessFile, $htaccessContent );
					fclose( $htaccessFile );
				}
			}

			// Need to at least create an empty password file otherwise access will just give a server error:
			if ( ! file_exists( $access->htpasswd ) ) {
				$htpasswdFile			=	fopen( $access->htpasswd, 'w' );

				if ( $htpasswdFile ) {
					fwrite( $htpasswdFile, '' );
					fclose( $htpasswdFile );
				}
			}
		} else {
			$access->htaccess			=	null;
			$access->htpasswd			=	null;
		}

		return $access;
	}

	/**
	 * Removes user from password file restricting access
	 *
	 * @param  UserTable  $user
	 * @param  string     $htpasswd
	 */
	function _removeAccess( $user, $htpasswd ) {
		if ( $htpasswd && file_exists( $htpasswd ) ) {
			$file_ht					=	fopen( $htpasswd, 'r' );

			if ( $file_ht ) {
				$content_size			=	filesize( $htpasswd );

				if ( $content_size ) {
					$content_file		=	fread( $file_ht, $content_size );
				} else {
					$content_file		=	'';
				}

				fclose( $file_ht );

				$newContents			=	$content_file;
				$users					=	explode( $this->_NL(), $content_file );

				for ( $i = 0; $i < count( $users ); $i++ ) {
					$string				=	explode( ':', $users[$i] );

					if ( $string[0] == $user->username ) {
						$newContents	=	preg_replace( '#(?<=^|\s)' . preg_quote( $users[$i], '#' ) . '(?=$|\s)#', '', $content_file );
					}
				}

				if ( $newContents && ( $content_file != $newContents ) ) {
					$file_ht			=	fopen( $htpasswd, 'w+' );

					if ( $file_ht ) {
						fwrite( $file_ht, $newContents );
						fclose( $file_ht );
					}
				}
			}
		}
	}

	/**
	 * Adds user to password file granting access
	 *
	 * @param  UserTableWithCBFolderAccess  $user
	 * @param  string                       $htpasswd
	 */
	function _addAccess( $user, $htpasswd ) {
		$file_ht	=	fopen( $htpasswd, 'a' );

		if ( $file_ht ) {
			fwrite( $file_ht, $user->username . ':' . ( $user->_folderaccess ? $user->_folderaccess : $this->password ) . $this->_NL() );
			fclose( $file_ht );
		}
	}

	/**
	 * Returns OS dependant line break
	 *
	 * @return string
	 */
	function _NL() {
		if ( strtoupper( substr( PHP_OS, 0, 3 ) ) == 'WIN' ) {
			$linebreak	=	"\r\n";
		} else {
			$linebreak	=	"\n";
		}

		return $linebreak;
	}

	/**
	 * Called at each change of user subscription state due to a plan activation or deactivation
	 *
	 * @param  UserTableWithCBFolderAccess  $user
	 * @param  string                       $status
	 * @param  int                          $planId
	 * @param  int                          $replacedPlanId
	 * @param  ParamsInterface              $integrationParams
	 * @param  string                       $cause              'PaidSubscription' (first activation only), 'SubscriptionActivated' (renewals, cancellation reversals), 'SubscriptionDeactivated', 'Denied'
	 * @param  string                       $reason             'N' new subscription, 'R' renewal, 'U'=update )
	 * @param  int                          $now                Unix time
	 */
	function onCPayUserStateChange( &$user, $status, /** @noinspection PhpUnusedParameterInspection */ $planId, /** @noinspection PhpUnusedParameterInspection */ $replacedPlanId, &$integrationParams, $cause, /** @noinspection PhpUnusedParameterInspection */ $reason, /** @noinspection PhpUnusedParameterInspection */ $now ) {
		if ( ! is_object( $user ) ) {
			return;
		}

		for ( $i = 1; $i <= 5; $i++ ) {
			$path			=	$integrationParams->get( 'folderaccess_path' . $i, null );
			$type			=	(int) $integrationParams->get( 'folderaccess_type' . $i, 0 );
			$index			=	(int) $integrationParams->get( 'folderaccess_index' . $i, 1 );

			if ( $path != null ) {
				// Even if no password was cached to the user object we still want to create the htaccess files to protect the directory:
				$msg		=	$integrationParams->get( 'folderaccess_msg', null );
				$access		=	$this->getFiles( $msg, $type, $path, $index );

				if ( ( $status === 'A' ) && ( $cause === 'PaidSubscription' ) ) {
					// If we've a cached password during the registration purchase process goahead and synchronize now otherwise we will at next login attempt:
					if ( isset( $user->_folderaccess ) && $user->_folderaccess ) {
						$this->_addAccess( $user, $access->htpasswd );
					}
				} elseif ( in_array( $status, array( 'X', 'C' ), true ) && ( $cause !== 'Pending' ) ) {
					$this->_removeAccess( $user, $access->htpasswd );
				}
			}
		}
	}
}
