<?php
/**
* Joomla Community Builder User Plugin: plug_fieldsprotectbysub
* @version $Id$
* @package plug_fieldsprotectbysub
* @subpackage cb.fieldsprotectbysub.php
* @author Beat
* @copyright Commercial
*/

use CB\Database\Table\FieldTable;
use CB\Database\Table\TabTable;
use CB\Database\Table\UserTable;
use CBLib\Application\Application;
use CBLib\Registry\ParamsInterface;
use CBLib\Registry\Registry;
use CBLib\Language\CBTxt;

/** ensure this file is being included by a parent file */
if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_PLUGINS;
//$_PLUGINS->registerUserFieldTypes( array( 'helloworldSpecial' => 'CBfield_helloworldSpecial' ) );
$_PLUGINS->registerUserFieldParams();
$_PLUGINS->registerFunction( 'onFieldIcons',					'onFieldIcons',								'CBfldProtectbysub' );
$_PLUGINS->registerFunction( 'onBeforeprepareFieldDataSave',	'onBeforeprepareFieldDataSave',				'CBfldProtectbysub' );
$_PLUGINS->registerFunction( 'onBeforegetFieldRow',				'onBeforegetFieldRow',						'CBfldProtectbysub' );
$_PLUGINS->registerFunction( 'onAfterbindSearchCriteria',		'onAfterbindSearchCriteria',				'CBfldProtectbysub' );
// tabs privacy:
$_PLUGINS->registerUserTabParams();
$_PLUGINS->registerFunction( 'onAfterTabsFetch',				'onAfterTabsFetch',							'getcbfieldsprotectbysubTab' );
$_PLUGINS->registerFunction( 'onAfterPrepareViewTabs',			'onAfterPrepareViewTabs',					'getcbfieldsprotectbysubTab' );
$_PLUGINS->registerFunction( 'onAfterEditATab',					'onAfterEditATab',							'getcbfieldsprotectbysubTab' );

/**
 * Class CBfieldsProtectbysubUtils
 * Utilities class
 */
class CBfieldsProtectbysubUtils
{
	/**
	 * Checks if user has an active subscription to a plan
	 *
	 * @param  int      $userId
	 * @param  int[]    $plans
	 * @return boolean
	 */
	static function _hasAtLeastOneActivePlan( $userId, $plans )
	{
		static $activeUsersPlans = array();

		if ( ! isset( $activeUsersPlans[$userId] ) ) {
			$activeUsersPlans[$userId]		=	array();
			$paidUserExtension				=	cbpaidUserExtension::getInstance( $userId );
			$subs							=	$paidUserExtension->getActiveSubscriptions();
			foreach ( array_keys( $subs ) as $k ) {
				$plan						=	$subs[$k]->getPlan();
				$plan_id					=	$plan->get( 'id');
				$activeUsersPlans[$userId][$plan_id]	=	true;				// $plan->getParam( 'cpay_image_image', null, 'integrations' );
			}
		}
		foreach ( array_keys( $activeUsersPlans[$userId] ) as $activePlanId ) {
			if ( in_array( $activePlanId, $plans ) ) {
				return true;
			}
		}
		return false;
	}

	/**
	 * Checks if $userId has at least one active plan if $privacyLevel is not 0
	 *
	 * @param  int       $userId
	 * @param  int      $privacyLevel
	 * @param  int[]    $plans
	 * @return boolean
	 */
	static function _anyPlanActive( $userId, $privacyLevel, $plans )
	{
		if ( $privacyLevel == 0 ) {
			return true;
		} elseif ( $userId ) {
			return CBfieldsProtectbysubUtils::_hasAtLeastOneActivePlan( $userId, $plans );
		} else {
			return false;
		}
		
	}

	/**
	 * Authorizes user to ...
	 *
	 * @param  ParamsInterface  $params  Settings of the plugin
	 * @param  int              $userId  User id to authorize
	 * @param  string           $reason  Reason to authorize
	 * @return boolean|string            Authorization or 'normal'
	 */
	static function _authorize( $params, $userId, $reason ) {
		switch ($reason) {
			/** @noinspection PhpMissingBreakStatementInspection */
			case 'list':
				$reason					=	'profile';
				// fall-through:
			case 'profile':
			case 'edit':
			case 'search':
				$privacyLevel			=	$params->get( 'plug_fieldsprotectbysub_level' );

				if ( $privacyLevel == 1 ) {
					$plansString		=	$params->get( 'plug_fieldsprotectbysub_profile' );
				} elseif ( $privacyLevel == 2 ) {
					$plansString		=	$params->get( 'plug_fieldsprotectbysub_' . $reason );
				} else {
					$plansString		=	'';
				}

				if ( $plansString != '' ) {
					$plans				=	explode( '|*|', $plansString );
					$auth				=	CBfieldsProtectbysubUtils::_anyPlanActive( $userId, $privacyLevel, $plans );
				} else {
					$auth				=	'normal';
				}
				break;
			case 'register':
			case 'adminfulllist':
				$auth					=	'normal';
				break;
			default:
				trigger_error( 'Unknown reason ' . $reason . ' in CBfieldsProtectbysubUtils::_authorize', E_USER_WARNING );
				$auth					=	false;
				break;
		}
		return $auth;
	}

	/**
	 * Authorizes user to view
	 *
	 * @param  ParamsInterface  $params  Settings of the plugin
	 * @param  int              $userId  User id to authorize
	 * @param  string           $reason  Reason to authorize
	 * @return boolean|string            Authorization or 'normal'
	 */
	static function _authorizeViewer( $params, $userId, $reason ) {
		$privacyLevel			=	$params->get( 'plug_fieldsprotectbysub_level_viewer' );
		if ( $privacyLevel == 1 ) {
			$plansString		=	$params->get( 'plug_fieldsprotectbysub_viewer_plans' );
		} elseif ( $privacyLevel == 2 ) {
			if ( $reason == 'search' ) {
				$plansString	=	$params->get( 'plug_fieldsprotectbysub_viewer_' . $reason );
			} else {
				$plansString	=	$params->get( 'plug_fieldsprotectbysub_viewer_plans' );
			}
		} else {
			$plansString		=	'';
		}
		if ( $plansString != '' ) {
			$plans				=	explode( '|*|', $plansString );
			$auth				=	CBfieldsProtectbysubUtils::_anyPlanActive( $userId, $privacyLevel, $plans );
		} else {
			$auth				=	'normal';
		}
		return $auth;
	}

	/**
	 * Authorizes user to view the viewed user $user
	 *
	 * @param  ParamsInterface  $params  Settings of the plugin
	 * @param  UserTable        $user    User to view
	 * @param  string           $output  Output type ('html', 'htmledit' or ...)
	 * @param  string           $reason  Reason to authorize
	 * @return boolean|string            Authorization or 'normal'
	 */
	static function authViewedViewer( $params, $user, $output, $reason ) {
		global $_CB_framework;

		$auth										=	'normal';

		if ( ( $reason != 'register' ) && ( $_CB_framework->getUi() == 1 ) ) {
			// frontend: (backend: do not interfer)
			$myId									=	$_CB_framework->myId();
			$privacyEditFE							=	0;		// no override of decision by default
			
			// check for field availability settings:
			$privacyLevel							=	$params->get( 'plug_fieldsprotectbysub_level', 0 );
			if ( $privacyLevel > 0 ) {

				if ( $myId ) {
					// check for moderators rights in frontend:
					switch ($reason) {
						case 'profile':
						case 'search':
							if ( $myId == $user->id ) {
								if ( ( $output == 'htmledit' ) && ( $reason != 'search' ) ) {
									//nothing to do here as plan-control is enough $privacyEditFE		=	$params->get( 'plug_fieldsprotectbysub_edit_owner', 0 );
								} else {
									$privacyEditFE		=	$params->get( 'plug_fieldsprotectbysub_profile_owner', 1 );
								}
							} elseif ( ( $myId != $user->id ) && Application::MyUser()->isGlobalModerator() ) {
								if ( $privacyLevel > 1 ) {
									if ( ( $output == 'htmledit' ) && ( $reason != 'search' ) ) {
										$privacyEditFE		=	$params->get( 'plug_fieldsprotectbysub_edit_mods', 0 );
									} else {
										$privacyEditFE		=	$params->get( 'plug_fieldsprotectbysub_profile_mods', 0 );
									}
								}
							}
							break;
						case 'register':
						case 'adminfulllist':
						default:
							$privacyEditFE			=	0;		// this case should not happen
							break;
					}
				}
	
				$auth								=	CBfieldsProtectbysubUtils::_authorize( $params, ( ( $reason == 'search' ) ? $myId : ( $user === null ? 0 : $user->id ) ), ( ( $reason == 'profile' ) && ( $output == 'htmledit' ) ) ? 'edit' : $reason );
	
				if ( ( $auth === false ) && ( $privacyEditFE == 1 ) ) {
					$auth							=	true;
				}
			}

			if ( $auth !== false ) {
				// check for field visibility by viewer settings:
				$privacyLevel						=	$params->get( 'plug_fieldsprotectbysub_level_viewer', 0 );
				if ( $privacyLevel > 0 ) {
					if ( ( $privacyEditFE == 0 ) && $myId ) {
						if ( $myId == $user->id ) {
							// check for moderators rights in frontend:
							$privacyEditFE			=	$params->get( 'plug_fieldsprotectbysub_viewer_owner', 1 );
						} elseif ( ( $privacyLevel > 1 ) && ( $myId != $user->id ) && Application::MyUser()->isGlobalModerator() ) {
							// check for moderators rights in frontend:
							$privacyEditFE			=	$params->get( 'plug_fieldsprotectbysub_viewer_mods', 0 );
						}
					}
					$viewedAuth						=	$auth;
					$auth							=	CBfieldsProtectbysubUtils::_authorizeViewer( $params, $myId, ( ( $reason == 'profile' ) && ( $output == 'htmledit' ) ) ? 'edit' : $reason );
					if ( ( $auth === 'normal' ) && ( $viewedAuth === true ) ) {
						$auth						=	true;
					}
					if ( ( $auth === false ) && ( $privacyEditFE == 1 ) ) {
						$auth						=	true;
					}
				}
			}
		}
		return $auth;
	}
}	// class CBfieldsProtectbysubUtils

class CBfldProtectbysub extends cbFieldHandler {

	function _authField( &$field, $user, $output, $reason ) {
		static $auth = array();

		$idx	=	$field->fieldid . '_' . ( $user === null ? '0' : $user->id ) . '_' . $reason . '_' . $output;
		if ( ! isset( $auth[$idx] ) ) {
			// first check if the tab is protected and not allowed and invisible:
			if ( $this->_checkIfFieldTabAllowed( $field, $user, $output, $reason ) === false ) {
				$auth[$idx]		=	false;
			}
			// then check if field is a real field and has params to be protected by this plugin:
			elseif ( ( $field->name === null ) || ( $field->params == null) )
			{
				// workaround for simulated sub-fields for userparams:
				$auth[$idx]		=	'normal';
			// finally check fields'own protection params:
			} else {
				$auth[$idx]		=	CBfieldsProtectbysubUtils::authViewedViewer( $field->params, $user, $output, $reason );
			}
		}
		return $auth[$idx];
	}

	/**
	 * Enter description here...
	 *
	 * @param  cbFieldHandler  $fieldHandler
	 * @param  FieldTable      $field
	 * @param  UserTable       $user
	 * @param  string          $output
	 * @param  string          $reason             'profile' for user profile view and edit, 'register' for registration
	 * @param  string          $tag                <tag
	 * @param  string          $type               type="$type"
	 * @param  string          $value              value="$value"
	 * @param  string          $additional         'xxxx="xxx" yy="y"'
	 * @param  string          $allValues
	 * @param  boolean         $displayFieldIcons  IN+OUT
	 * @param  boolean         $required
	 * @return string                              HTML
	 */
	function onFieldIcons( &$fieldHandler, &$field, &$user, $output, $reason, /** @noinspection PhpUnusedParameterInspection */ $tag, /** @noinspection PhpUnusedParameterInspection */ $type, /** @noinspection PhpUnusedParameterInspection */ $value, /** @noinspection PhpUnusedParameterInspection */ $additional, /** @noinspection PhpUnusedParameterInspection */ $allValues, &$displayFieldIcons, $required ) {
		global $_CB_framework, $_CB_fieldIconDisplayed;

		if ( $displayFieldIcons && ( $reason != 'search' ) ) {
			$auth							=	$this->_authField( $field, $user, $output, $reason );
			if ( $auth === true ) {
				$msgIcon					=	'&nbsp;' . $field->params->get( 'plug_cbfieldprotsub_msgIcon', null );
			} elseif ( $auth === 'normal' ) {
				$msgIcon					=	'';
			} else {
				return null;
			}
			if ( ( ! $displayFieldIcons ) || isset( $_CB_fieldIconDisplayed[$field->fieldid] ) ) {
				return $msgIcon;
			} else {
				$_CB_fieldIconDisplayed[$field->fieldid]	=	true;		// CB < 1.2.2 method this and line below next
				$displayFieldIcons							=	false;		// CB 1.2.2+ method compatible with 1.2.1
				return getFieldIcons( $_CB_framework->getUi(), $required, $field->profile, $fieldHandler->getFieldDescription( $field, $user, $output, $reason ), $fieldHandler->getFieldTitle( $field, $user, $output, $reason ), false, $field->params->get( 'fieldLayoutIcons', null ) )
				. $msgIcon;
			}
		}
		return null;
	}
	/**
	 * Prepares field data for saving to database (safe transfer from $postdata to $user)
	 * Override
	 *
	 * @param  FieldTable  $field
	 * @param  UserTable   $user      RETURNED populated: touch only variables related to saving this field (also when not validating for showing re-edit)
	 * @param  array       $postdata  Typically $_POST (but not necessarily), filtering required.
	 * @param  string      $reason    'profile' for save user edit, 'register' for save registration
	 * @return NULL                   //TBD should be True: All fields have validated, False: Some fields didn't validate
	 */
	function onBeforeprepareFieldDataSave ( &$field, &$user, /** @noinspection PhpUnusedParameterInspection */ &$postdata, $reason ) {
		$auth							=	$this->_authField( $field, $user, 'htmledit', $reason );
		if ( $auth === false ) {
			return '1';
		}
		return null;
	}
	/**
	 * Returns a field in specified format
	 *
	 * @param  FieldTable  $field
	 * @param  UserTable   $user
	 * @param  string      $output      'html', 'xml', 'json', 'php', 'csvheader', 'csv', 'rss', 'fieldslist', 'htmledit'
	 * @param  string      $formatting  'table', 'td', 'span', 'div', 'none'
	 * @param  string      $reason      'profile' for user profile view and edit, 'register' for registration
	 * @param  int         $list_compare_types   IF reason == 'search' : 0 : simple 'is' search, 1 : advanced search with modes, 2 : simple 'any' search
	 * @return mixed
	 */
	function onBeforegetFieldRow( &$field, &$user, $output, /** @noinspection PhpUnusedParameterInspection */ $formatting, $reason, /** @noinspection PhpUnusedParameterInspection */ $list_compare_types ) {
		$auth								=	$this->_authField( $field, $user, $output, $reason );
		if ( $auth === false ) {
			// not authorized access
			$result							=	' ';
		} else {
			$result							=	'';
		}
		return $result;
	}
	/**
	 * Accessor:
	 * Returns a field in specified format
	 *
	 * @param  FieldTable  $field
	 * @param  UserTable    $user
	 * @param  string                $output  'html', 'xml', 'json', 'php', 'csvheader', 'csv', 'rss', 'fieldslist', 'htmledit'
	 * @param  string                $reason  'profile' for user profile view and edit, 'register' for registration, 'list' for user-lists
	 * @param  int                   $list_compare_types   IF reason == 'search' : 0 : simple 'is' search, 1 : advanced search with modes, 2 : simple 'any' search
	 * @return mixed
	 */
	function getField( &$field, &$user, $output, $reason, $list_compare_types ) {
		$value								=	$user->get( $field->name );
		return $this->_formatFieldOutput( $field->name, $value, $output, false );
	}
	/**
	 * Finder:
	 * Prepares field data for saving to database (safe transfer from $postdata to $user)
	 * Override
	 *
	 * @param  FieldTable  $field
	 * @param  UserTable   $searchVals  RETURNED populated: touch only variables related to saving this field (also when not validating for showing re-edit)
	 * @param  array       $postdata    Typically $_POST (but not necessarily), filtering required.
	 * @param  int         $list_compare_types   IF reason == 'search' : 0 : simple 'is' search, 1 : advanced search with modes, 2 : simple 'any' search
	 * @param  string      $reason      'profile' for save user edit, 'register' for save registration
	 * @param  string      $query
	 * @return array of cbSqlQueryPart
	 */
	function onAfterbindSearchCriteria( &$field, &$searchVals, &$postdata, $list_compare_types, $reason, &$query ) {
		//TBD:
	}
	/**
	 * Checks if the tab of the field is allowed for the user
	 *
	 * @param  FieldTable  $field
	 * @param  UserTable   $user
	 * @param  string      $output  'html', 'xml', 'json', 'php', 'csvheader', 'csv', 'rss', 'fieldslist', 'htmledit'
	 * @param  string      $reason  'profile' for user profile view and edit, 'register' for registration, 'list' for user-lists
	 * @return boolean              True: allowed, False: not allowed/visible
	 */
	function _checkIfFieldTabAllowed( $field, $user, $output, $reason ) {
		if ( $field->tabid ) {
			$tab					=	$this->_getTab( (int) $field->tabid );
			if ( $tab ) {
				return ( getcbfieldsprotectbysubTab::authTab( $tab, $user, $output, $reason ) !== false );
			} else {
				// this is almost an error condition...: well let's not interfere:
				return true;
			}
		} else {
			// some system subfields, like editor type userparam does not have a tab:
			return true;
		}
	}
	/**
	 * Returns the tab object corresponding to a tab id.
	 * Tab must be enabled and accessible to the my user.
	 * This function is temporary until we rework the tabs manager:		//TBD to be improved when tabs manager is redone.
	 *
	 * @param  int                 $tabid
	 * @return TabTable
	 */
	function _getTab( $tabid ) {
		global $_CB_database;

		static $cache			=	null;

		$tabid					=	(int) $tabid;
		if ( ! isset( $cache ) ) {
			// do exactly same SQL query as in _loadTabsList for now to use the SQL caching:
			$_CB_database->setQuery( "SELECT * FROM #__comprofiler_tabs t"
			. "\n WHERE t.enabled=1"
			. "\n AND t.viewaccesslevel IN (" . implode( ',', Application::MyUser()->getAuthorisedViewLevels() ) .')'
			. "\n ORDER BY t.position, t.ordering" );
			$cache				=	$_CB_database->loadObjectList( 'tabid', '\CB\Database\Table\TabTable', array( &$_CB_database ) );
		}
		if ( isset( $cache[$tabid] ) ) {
			if ( ! is_object( $cache[$tabid]->params ) ) {
				$cache[$tabid]->params				=	new Registry( $cache[$tabid]->params );
			}
			return $cache[$tabid];
		} else {
			$null				=	null;
			return $null;
		}
	}
}	// class CBfldProtectbysub

class getcbfieldsprotectbysubTab extends cbTabHandler
{
	static function authTab( $tab, $user, $output, $reason ) {
		static $auth = array();

		$idx	=	$tab->tabid . '_' . ( $user === null ? '0' : $user->id ) . '_' . $reason . '_' . $output;
		if ( ! isset( $auth[$idx] ) ) {
			if ( ! $tab->params instanceof ParamsInterface ) {
				$tab->params	=	new Registry( $tab->params );
			}

			$auth[$idx]			=	CBfieldsProtectbysubUtils::authViewedViewer( $tab->params, $user, $output, $reason );
		}
		return $auth[$idx];
	}

	/**
	 * Called after tabs rendering called but before returning the rendering
	 *
	 * @param TabTable[] $tabs
	 * @param UserTable  $user
	 * @param string     $reason ( 'profile', 'register', 'list', 'edit', 'editsave' )
	 */
	function onAfterTabsFetch( &$tabs, &$user, $reason ) {
		static $done = 0;
		if ( $reason != 'register' ) {
			if ( ! $done++ ) {
	//		if ( $user && ( $user->id > 0 ) /* && ( $_CB_framework->myId() != $user->id ) && ( $reason != 'edit' ) && ( $reason != 'editsave' ) */ ) {
	
				if ( in_array( $reason, array( 'edit', 'editsave' ) ) ) {
					$reason											=	'profile';
					$output											=	'htmledit';
				} else {
					$output											=	'html';
				}
				
				foreach ( array_keys( $tabs ) as $k ) {
					$auth											=	getcbfieldsprotectbysubTab::authTab( $tabs[$k], $user, $output, $reason );
	
					if ( $auth === false ) {
						global $_CB_framework;

						$visitorTxt									=	( ( ( $user === null ) || ( $user->id == 0 ) || ( $_CB_framework->myId() != $user->id ) ) ? '_visitor' : '' );

						if ( ! $tabs[$k]->params instanceof ParamsInterface ) {
							$tabs[$k]->params						=	new Registry( $tabs[$k]->params );
						}

						if ( $tabs[$k]->params->get( 'plug_fieldsprotectbysub_hideMessage' . $visitorTxt ) == '' ) {
							unset( $tabs[$k] );
						}
					}
				}
			}
		}
	}
	/**
	 * Called after a tabbed tab is rendered
	 *
	 * @param  string     $content
	 * @param  TabTable   $tab
	 * @param  UserTable  $user
	 * @param  string     $output
	 * @param  string     $reason
	 */
	function chngTabDisplay( &$content, &$tab, &$user, $output, $reason ) {
		global $_CB_framework;

		$auth										=	getcbfieldsprotectbysubTab::authTab( $tab, $user, $output, $reason );
		if ( $auth !== 'normal' ) {
			$visitorTxt								=	( ( ( $user === null ) || ( $_CB_framework->myId() != $user->id ) ) ? '_visitor' : '' );

			if ( ! $tab->params instanceof ParamsInterface ) {
				$tab->params						=	new Registry( $tab->params );
			}

			if ( $auth === true ) {
				$txtOk								=	$tab->params->get( 'plug_fieldsprotectbysub_showMessage' . $visitorTxt );
				if ( $txtOk ) {
					$displayText					=	CBTxt::T( $txtOk );
					$content						=	'<div class="cbpaidTabProtection cbpaidTabProtectionAllowed">' . $displayText . '</div>' . $content;
				}
			} elseif ( $auth === false ) {
				$txtKo								=	$tab->params->get( 'plug_fieldsprotectbysub_hideMessage' . $visitorTxt );
				if ( $txtKo ) {
					$displayText					=	CBTxt::T( $txtKo );
					$content						=	'<div class="cbpaidTabProtection cbpaidTabProtectionDenied">' . $displayText . '</div>';
				}
			}
		}
	}
	function onAfterPrepareViewTabs( &$tabsContents, &$tabsToDisplay, &$user, /** @noinspection PhpUnusedParameterInspection */ $position, /** @noinspection PhpUnusedParameterInspection */ $tabid ) {
		foreach ($tabsToDisplay as $k => $tab ) {
			if ( $tabsContents[$k] != '' ) {
				$this->chngTabDisplay( $tabsContents[$k], $tab, $user, 'html', 'profile' );
			}
		}
	}
	/**
	 * Called after a tabbed tab is rendered
	 *
	 * @param  string     $content
	 * @param  TabTable   $tab
	 * @param  UserTable  $user
	 * @param  array      $postdata
	 * @param  string     $output
	 * @param  string     $formatting
	 * @param  string     $reason
	 * @param  boolean    $tabbed
	 */
	function onAfterEditATab( &$content, &$tab, &$user, /** @noinspection PhpUnusedParameterInspection */ &$postdata, $output, /** @noinspection PhpUnusedParameterInspection */ $formatting, $reason, /** @noinspection PhpUnusedParameterInspection */ $tabbed ) {
		$this->chngTabDisplay( $content, $tab, $user, $output, $reason );
	}
}	// class getcbfieldsprotectbysubTab
