<?php
/**
* @version $Id: $
* @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
* @subpackage Template for Paid Subscriptions
* @copyright (C) 2007-2022 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Application\Application;
use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class cbpaidPaymentsListView extends cbpaidTemplateHandler
{
	/** @var cbpaidPayment[]  */
	public $_model			=	array();
	/** @var UserTable */
	public $user			=	null;
	/** @var cbPageNav */
	public $paging			=	null;
	/** @var string */
	public $title			=	null;
	/** @var array */
	public $items			=	array();
	/** @var array */
	public $invoices		=	array();
	/** @var array */
	public $amounts			=	array();
	/** @var array */
	public $actions			=	array();
	/** @var string */
	public $paymentsListUrl	=	null;

	/**
	 * @param cbpaidPayment[] $payments
	 */
	public function __construct( $payments )
	{
		parent::__construct();

		$this->_model	=	$payments;
	}

	/**
	 * @return int
	 */
	public function version()
	{
		return 1;
	}

	/**
	 * @param int       $paymentsNumber
	 * @param UserTable $user
	 * @return string
	 */
	public function drawProfilePaymentsLink( $paymentsNumber, $user )
	{
		global $_CB_framework;

		if ( Application::MyUser()->getUserId() !== $user->getInt( 'id', 0 ) ) {
			$this->paymentsListUrl	=	$_CB_framework->pluginClassUrl( array( 'plugin' => 'cbpaidsubscriptions', 'do' => 'showpaymentslist', 'user' => $user->getInt( 'id', 0 ) ) );
		} else {
			$this->paymentsListUrl	=	$_CB_framework->pluginClassUrl( array( 'plugin' => 'cbpaidsubscriptions', 'do' => 'showpaymentslist' ) );
		}

		$this->user					=	$user;
		$this->title				=	$this->_paymentsTitle( $paymentsNumber, $user );

		return $this->display( 'paymentslistlink' );
	}

	/**
	 * @param UserTable $user
	 * @param cbPageNav $paging
	 * @return string
	 */
	public function drawPaymentsHistoryList( $user, $paging )
	{
		$this->user						=	$user;
		$this->paging					=	$paging;
		$this->title					=	$this->_paymentsTitle( $paging->total, $user );

		$params							=	cbpaidApp::settingsParams();
		$showInvoices					=	( $params->getString( 'invoice_number_format' ) && $params->getBool( 'show_invoices', true ) );

		$baseClass						=	cbpaidApp::getBaseClass();
		$cbpaidMoney					=	cbpaidMoney::getInstance();

		static $baskets					=	array();

		foreach ( $this->_model as $id => $payment ) {
			$basketId					=	$payment->getInt( 'payment_basket_id', 0 );

			if ( ! isset( $baskets[$basketId] ) ) {
				$paymentBasket			=	new cbpaidPaymentBasket();

				$paymentBasket->load( $basketId );

				$baskets[$basketId]		=	$paymentBasket;
			}

			$name						=	htmlspecialchars( $payment->getString( 'item_name' ) );

			if ( $showInvoices ) {
				$invoiceUrl				=	$baseClass->getInvoiceUrl( $baskets[$basketId] );

				$name					=	'<a onclick="window.open( \'' . $invoiceUrl . '\', \'cbinvoice\', \'status=no,toolbar=no,scrollbars=yes,titlebar=no,menubar=no,resizable=yes,width=640,height=480,directories=no,location=no\' ); return false;" target="_blank" href="' . $invoiceUrl . '" class="cbregInvoiceLink">'
										.		$name
										.	'</a>';
			}

			$this->items[$id]			=	$name;
			$this->amounts[$id]			=	$cbpaidMoney->renderPrice( $payment->getFloat( 'mc_gross' ), $payment->getString( 'mc_currency' ) );

			$invoiceActions				=	$baskets[$basketId]->renderMaintenanceButtonsHtml();

			$this->actions[$id]			=	( $invoiceActions ? implode( ' | ', $invoiceActions ) : null );
		}

		return $this->display( 'default' );
	}

	/**
	 * @uses \CBLib\Application\Application::Input()
	 *
	 * @param int       $paymentsNumber
	 * @param UserTable $user
	 * @return string
	 */
	protected function _paymentsTitle( $paymentsNumber, $user )
	{
		$basketId					=	Application::Input()->getInt( 'basket' );
		$invoiceId					=	Application::Input()->getString( 'invoice' );
		$paymentId					=	Application::Input()->getString( 'payment' );
		$periodText					=	null;

		if ( ! ( $basketId || $invoiceId || $paymentId ) ) {
			$paymentsShowPeriod		=	cbpaidApp::settingsParams()->getString( 'payments_history_show_period', '0000-06-00 00:00:00' );

			if ( $paymentsShowPeriod && ( $paymentsShowPeriod !== '0000-00-00 00:00:00' ) ) {
				$periodText			=	cbpaidTimes::getInstance()->renderPeriod( $paymentsShowPeriod, 1, false );
			}
		}

		if ( Application::MyUser()->getUserId() === $user->getInt( 'id', 0 ) ) {
			if ( $periodText ) {
				$plansTitle 		=	sprintf( CBTxt::Th( 'Your payments of last %s' ), htmlspecialchars( $periodText ) );
			} elseif ( $paymentsNumber === 1 ) {
				$plansTitle			=	CBTxt::Th( 'Your payment' );
			} else {
				$plansTitle			=	CBTxt::Th( 'Your payments' );
			}
		} elseif ( $periodText ) {
			$plansTitle				=	sprintf( CBTxt::Th( "%s's payments of last %s" ), $user->getFormattedName(), htmlspecialchars( $periodText ) );
		} else {
			$plansTitle 			=	sprintf( CBTxt::Th( "%s's payments" ), $user->getFormattedName() );
		}

		return $plansTitle;
	}
}
