<?php
/**
* @version $Id: $
* @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
* @subpackage Template for Paid Subscriptions
* @copyright (C) 2007-2022 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Application\Application;
use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class cbpaidInvoicesListView extends cbpaidTemplateHandler
{
	/** @var cbpaidPaymentBasket[]  */
	public $_model			=	array();
	/** @var UserTable */
	public $user			=	null;
	/** @var cbPageNav */
	public $paging			=	null;
	/** @var string */
	public $title			=	null;
	/** @var array */
	public $items			=	array();
	/** @var array */
	public $amounts			=	array();
	/** @var array */
	public $actions			=	array();
	/** @var bool */
	public $invoiceNumbers	=	true;
	/** @var string */
	public $invoicesListUrl	=	null;

	/**
	 * @param cbpaidPaymentBasket[] $invoices
	 */
	public function __construct( $invoices )
	{
		parent::__construct();

		$this->_model	=	$invoices;
	}

	/**
	 * @return int
	 */
	public function version()
	{
		return 1;
	}

	/**
	 * @param int       $invoicesNumber
	 * @param UserTable $user
	 * @return string
	 */
	public function drawProfileInvoicesLink( $invoicesNumber, $user )
	{
		global $_CB_framework;

		if ( Application::MyUser()->getUserId() !== $user->getInt( 'id', 0 ) ) {
			$this->invoicesListUrl	=	$_CB_framework->pluginClassUrl( array( 'plugin' => 'cbpaidsubscriptions', 'do' => 'showinvoiceslist', 'user' => $user->getInt( 'id', 0 ) ) );
		} else {
			$this->invoicesListUrl	=	$_CB_framework->pluginClassUrl( array( 'plugin' => 'cbpaidsubscriptions', 'do' => 'showinvoiceslist' ) );
		}

		$this->user					=	$user;
		$this->title				=	$this->_invoicesTitle( $invoicesNumber, $user );

		return $this->display( 'invoiceslistlink' );
	}

	/**
	 * @param UserTable $user
	 * @param cbPageNav $paging
	 * @return string
	 */
	public function drawInvoicesList( $user, $paging )
	{
		$this->user						=	$user;
		$this->paging					=	$paging;
		$this->title					=	$this->_invoicesTitle( $paging->total, $user );

		$params							=	cbpaidApp::settingsParams();

		$this->invoiceNumbers			=	( $params->getString( 'invoice_number_format' ) && $params->getBool( 'show_invoices', true ) );

		$baseClass						=	cbpaidApp::getBaseClass();
		$cbpaidMoney					=	cbpaidMoney::getInstance();

		foreach ( $this->_model as $id => $invoice ) {
			$this->items[$id]			=	$this->drawInvoiceLink( htmlspecialchars( $invoice->getString( 'item_name' ) ), $baseClass->getInvoiceUrl( $invoice ) );
			$this->amounts[$id]			=	$cbpaidMoney->renderPrice( $invoice->getFloat( 'mc_gross' ), $invoice->getString( 'mc_currency' ) );

			$invoiceActions				=	$invoice->renderMaintenanceButtonsHtml();

			$this->actions[$id]			=	( $invoiceActions ? implode( ' | ', $invoiceActions ) : null );
		}

		return $this->display( 'default' );
	}

	/**
	 * Draws the invoice link that opens invoice in a new window
	 *
	 * @param  string  $linkContentHtml
	 * @param  string  $invoiceDetailsUrl
	 * @return string
	 */
	public function drawInvoiceLink( $linkContentHtml, $invoiceDetailsUrl )
	{
		return	'<a onclick="window.open( \'' . $invoiceDetailsUrl . '\', \'cbinvoice\', \'status=no,toolbar=no,scrollbars=yes,titlebar=no,menubar=no,resizable=yes,width=640,height=480,directories=no,location=no\' ); return false;" target="_blank" href="' . $invoiceDetailsUrl . '" class="cbregInvoiceLink">'
			.		$linkContentHtml
			.	'</a>';
	}

	/**
	 * @param int       $invoicesNumber
	 * @param UserTable $user
	 * @return string
	 */
	protected function _invoicesTitle( $invoicesNumber, $user )
	{
		$basketId					=	Application::Input()->getInt( 'basket' );
		$invoiceId					=	Application::Input()->getString( 'invoice' );
		$periodText					=	null;

		if ( ! ( $basketId || $invoiceId ) ) {
			$invoicesShowPeriod		=	cbpaidApp::settingsParams()->getString( 'invoices_show_period', '0000-06-00 00:00:00' );

			if ( $invoicesShowPeriod && ( $invoicesShowPeriod !== '0000-00-00 00:00:00' ) ) {
				$periodText			=	cbpaidTimes::getInstance()->renderPeriod( $invoicesShowPeriod, 1, false );
			}
		}

		if ( Application::MyUser()->getUserId() === $user->getInt( 'id', 0 ) ) {
			if ( $periodText ) {
				$plansTitle 		=	sprintf( CBTxt::Th( 'Your invoices of last %s' ), htmlspecialchars( $periodText ) );
			} elseif ( $invoicesNumber === 1 ) {
				$plansTitle			=	CBTxt::Th( 'Your invoice' );
			} else {
				$plansTitle			=	CBTxt::Th( 'Your invoices' );
			}
		} elseif ( $periodText ) {
			$plansTitle				=	sprintf( CBTxt::Th( "%s's invoices of last %s" ), $user->getFormattedName(), htmlspecialchars( $periodText ) );
		} else {
			$plansTitle 			=	sprintf( CBTxt::Th( "%s's invoices" ), $user->getFormattedName() );
		}

		return $plansTitle;
	}
}
