<?php
/**
* @version $Id: $
* @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
* @subpackage Template for Paid Subscriptions
* @copyright (C) 2007-2022 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Application\Application;
use CBLib\Language\CBTxt;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/** @var cbpaidInvoicesListView $this */

global $_CB_framework;

$tmplVersion	=	1;	// This is the template version that needs to match
?>
<div class="cbsubsInvoices">
	<?php if ( $this->title ) { ?>
	<div class="mb-3 border-bottom cb-page-header cbsubsInvoicesHeader">
		<h3 class="m-0 p-0 mb-2 cb-page-header-title"><?php echo $this->title; ?></h3>
	</div>
	<?php } ?>
	<?php if ( $this->_model ) { ?>
	<div class="table-responsive cbsubsInvoicesList">
		<table class="m-0 table table-bordered cbsubsInvoicesListTable">
			<thead>
				<tr>
					<th style="width: 15%" scope="col" class="text-center cbsubsInvoicesDate">
						<?php echo CBTxt::Th( 'INVOICE_LIST_DATE', 'Date' ); ?>
					</th>
					<th scope="col" class="text-wrap cbsubsInvoicesItem">
						<?php echo CBTxt::Th( 'INVOICE_LIST_ITEM', 'Item' ); ?>
					</th>
					<th style="width: 15%" scope="col" class="d-none d-sm-table-cell text-wrap text-center cbsubsInvoicesAmount">
						<?php echo CBTxt::Th( 'INVOICE_LIST_AMOUNT', 'Amount' ); ?>
					</th>
					<th style="width: 20%" scope="col" class="text-center cbsubsInvoicesState">
						<?php echo CBTxt::Th( 'INVOICE_LIST_STATE', 'State' ); ?>
					</th>
					<th style="width: 15%" scope="col" class="d-none d-sm-table-cell text-wrap text-center cbsubsInvoicesType">
						<?php echo CBTxt::Th( 'INVOICE_LIST_TYPE', 'Type' ); ?>
					</th>
				</tr>
			</thead>
			<tbody>
				<?php foreach ( $this->_model as /** @var cbpaidPaymentBasket $row */ $id => $row ) { ?>
				<tr>
					<td style="width: 15%" class="text-center align-middle cbsubsInvoicesDate">
						<?php echo cbTooltip( null, cbFormatDate( $row->getString( 'time_initiated' ) ), null, null, null, cbFormatDate( $row->getString( 'time_initiated' ), true, false ), null, 'data-cbtooltip-simple="true"' ); ?>
					</td>
					<td class="text-wrap cbsubsInvoicesItem">
						<?php echo $this->items[$id]; ?>
						<?php if ( $this->invoiceNumbers && $row->getString( 'invoice' ) ) { ?>
						<div class="text-small text-muted">
							<?php echo cbTooltip( null, CBTxt::T( 'Invoice Number' ), null, null, null, htmlspecialchars( $row->getString( 'invoice' ) ), null, 'data-cbtooltip-simple="true"' ); ?>
						</div>
						<?php } ?>
					</td>
					<td style="width: 15%" class="d-none d-sm-table-cell text-wrap text-center align-middle cbsubsInvoicesAmount">
						<?php echo $this->amounts[$id]; ?>
					</td>
					<td style="width: 20%" class="text-center align-middle cbsubsInvoicesState">
						<?php if ( $row->getString( 'payment_status' ) === 'Pending' ) { ?>
							<?php echo sprintf( CBTxt::T( 'Waiting for %s' ), ( $row->getString( 'pending_reason' ) ? htmlspecialchars( $row->translatedPendingReason() ) : CBTxt::T( 'Payment' ) ) ); ?>
						<?php } else { ?>
							<?php echo htmlspecialchars( $row->translatedPaymentStatus() ); ?>
						<?php } ?>
						<?php if ( $this->actions[$id] ) { ?>
						<div class="text-small">
							<?php echo $this->actions[$id]; ?>
						</div>
						<?php } ?>
					</td>
					<td style="width: 15%" class="d-none d-sm-table-cell text-wrap text-center align-middle cbsubsInvoicesType">
						<?php echo htmlspecialchars( ucwords( $row->translatedPaymentType() ) ); ?>
					</td>
				</tr>
				<?php } ?>
			</tbody>
		</table>
	</div>
	<?php } ?>
	<?php if ( $this->paging->total > $this->paging->limit ) { ?>
	<div class="mt-2 cbsubsInvoicesPaging">
		<?php echo $this->paging->getPagesLinks(); ?>
	</div>
	<?php } ?>
	<?php if ( ! Application::Application()->isClient( 'administrator' ) ) { ?>
	<div class="mt-2 cbControlButtonsLine cbsubsInvoicesBack">
		<a href="<?php echo $_CB_framework->userProfileUrl( $this->user->getInt( 'id', 0 ), true, 'getcbpaidsubscriptionsTab' ); ?>">
			<?php echo CBTxt::Th( 'Click here to go back to your user profile' ); ?>
		</a>
	</div>
	<?php } ?>
</div>
