<?php
/**
* @version $Id: paybutton.php 1465 2012-07-10 17:37:13Z beat $
* @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
* @subpackage Template for Paid Subscriptions
* @copyright (C) 2007-2022 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;

/** ensure this file is being included by a parent file */
if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_CB_framework;

$tmplVersion		=	1;	// This is the template version that needs to match
$buttonCSSClass		=	trim( (string) $this->buttonCssClass );
$buttonText			=	'';
$buttonStack		=	'';

if ( ( ! $buttonCSSClass ) && ( strpos( $this->buttonImageOrText, '/plug_cbpaidsubscriptions/icons/cards/' ) !== false ) && ( strpos( $this->buttonImageOrText, 'cc_' ) === false ) ) {
	// Style default card images as buttons:
	$buttonCSSClass					=	'btn btn-light border-secondary cbpaidCCimageButton';

	// Check if we're a pseudo pay now or subscribe button so we can point to the original image, but only if the image doesn't exist:
	if ( ! file_exists( str_replace( $_CB_framework->getCfg( 'live_site' ), $_CB_framework->getCfg( 'absolute_path' ), $this->buttonImageOrText ) ) ) {
		if ( strpos( $this->buttonImageOrText, '_pay.png' ) !== false ) {
			$this->buttonImageOrText	=	str_replace( '_pay.png', '.png', $this->buttonImageOrText );

			$buttonText					=	CBTxt::T( 'BUTTON_IMG_PAY_NOW', 'PAY NOW' );
		} elseif ( strpos( $this->buttonImageOrText, '_subscribe.png' ) !== false ) {
			$this->buttonImageOrText	=	str_replace( '_subscribe.png', '.png', $this->buttonImageOrText );

			$buttonText					=	CBTxt::T( 'BUTTON_IMG_SUBSCRIBE', 'SUBSCRIBE' );
		} elseif ( strpos( $this->buttonImageOrText, '_checkout.png' ) !== false ) {
			$this->buttonImageOrText	=	str_replace( '_checkout.png', '.png', $this->buttonImageOrText );

			$buttonText					=	CBTxt::T( 'BUTTON_IMG_CHECKOUT', 'CHECKOUT' );
		} elseif ( strpos( $this->buttonImageOrText, 'offline.png' ) !== false ) {
			$buttonText					=	CBTxt::T( 'BUTTON_IMG_PAY_OFFLINE', 'PAY OFFLINE' );
		} elseif ( ( strpos( $this->buttonImageOrText, '_cards' ) !== false ) && preg_match('/_cards(?:_([a-zA-Z_]+))?\.png/', $this->buttonImageOrText, $matches ) ) {
			$this->buttonImageOrText	=	preg_replace( '/_cards(?:_[a-zA-Z_]+)?\.png/', '.png', $this->buttonImageOrText );

			$buttonStack				=	'<img src="' . htmlspecialchars( cbpaidApp::renderCCImage( ( $matches[1] ?? 'visa_mc_am_discover' ), true ) ) . '" alt="" class="mw-100" />';
			$buttonCSSClass				.=	' cbpaidCCimageStack';
		}
	}
}
?>
<div class="d-inline-block mb-3 mr-3 cbpaidCCbutton cbpaidButton_<?php echo htmlspecialchars( $this->payNameForCssClass ); ?>" id="<?php echo htmlspecialchars( $this->butId ); ?>">
	<form action="<?php echo htmlspecialchars( $this->formTargetUrl ); ?>" method="post" class="m-0">
<?php
	if ( preg_match( "/(\\.jpg|\\.png|\\.gif)\$/i", $this->buttonImageOrText ) ) {
		if ( $buttonCSSClass || $buttonText || $buttonStack ) {
?>
		<button type="submit" class="<?php echo htmlspecialchars( $buttonCSSClass ) . ' '; ?>cbpaidCCimageInput" name="BPay" title="<?php echo htmlspecialchars( $this->titleText ); ?>">
			<img src="<?php echo htmlspecialchars( $this->buttonImageOrText ); ?>" alt="<?php echo htmlspecialchars( $this->altText ); ?>" />
			<?php echo $buttonStack; ?>
			<?php if ( $buttonText ) { ?>
			<span class="text-small font-weight-bold">
				<?php echo $buttonText; ?>
			</span>
			<?php } ?>
		</button>
<?php
	} else {
?>
		<input type="image" src="<?php echo htmlspecialchars( $this->buttonImageOrText ); ?>" class="cbpaidCCimageInput" name="BPay" alt="<?php echo htmlspecialchars( $this->altText ); ?>" title="<?php echo htmlspecialchars( $this->titleText ); ?>" />
<?php
		}
?>
<?php
	} else {
?>
		<input type="submit" class="<?php echo ( $buttonCSSClass ? htmlspecialchars( $buttonCSSClass ) . ' ' : '' ); ?>cbpaidCCbuttonInput" name="BPay" value="<?php echo htmlspecialchars( $this->buttonImageOrText ); ?>" alt="<?php echo htmlspecialchars( $this->altText ); ?>" title="<?php echo htmlspecialchars( $this->titleText ); ?>" />
<?php
	}
		echo $this->txtHiddenInputs;
?>
	</form>
</div>
