<?php
/**
* @version $Id: cbsubs.sqlactions.php 1489 2012-07-16 14:57:45Z beat $
* @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
* @subpackage Plugin for Paid Subscriptions
* @copyright (C) 2007-2022 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CBLib\Registry\ParamsInterface;
use CBLib\Database\Driver\CmsDatabaseDriver;

/** ensure this file is being included by a parent file */
if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_PLUGINS;
$_PLUGINS->registerFunction( 'onCPayUserStateChange', 'onCPayUserStateChange', 'getcpaycbsqlactionsTab' );


/**
* CBSubs SQL Actions integration plugin class
*/
class getcpaycbsqlactionsTab extends cbTabHandler {
	/**
	 * Called at each change of user subscription state due to a plan activation or deactivation
	 *
	 * @param  UserTable        $user
	 * @param  string           $status
	 * @param  int              $planId
	 * @param  int              $replacedPlanId
	 * @param  ParamsInterface  $integrationParams
	 * @param  string           $cause              'PaidSubscription' (first activation only), 'SubscriptionActivated' (renewals, cancellation reversals), 'SubscriptionDeactivated', 'Denied'
	 * @param  string           $reason             'N' new subscription, 'R' renewal, 'U'=update
	 * @param  int              $now                Unix time
	 * @param cbpaidSomething   $subscription
	 */
	public function onCPayUserStateChange( &$user, $status, $planId, $replacedPlanId, &$integrationParams, $cause, $reason, /** @noinspection PhpUnusedParameterInspection */ $now, &$subscription ) {
		if ( ! $user ) {
			return;
		}

		if ( ( $status == 'A' ) && ( $cause == 'PaidSubscription' ) && ( $reason != 'R' ) ) {
			$event					=	'activation';
		} elseif ( ( $status == 'A' ) && ( $cause == 'PaidSubscription' ) && ( $reason == 'R' ) ) {
			$event					=	'renew';
		} elseif ( ( $status == 'X' ) && ( $cause != 'Pending' ) ) {
			$event					=	'expiry';
		} elseif ( ( $status == 'C' ) && ( $cause != 'Pending' ) ) {
			$event					=	'deactivation';
		} else {
			// } elseif ( ( $status == 'C' ) && ( $cause == 'SubscriptionDeactivated' ) ) { when the Cancel payment link is clicked: nothing to do here.
			$event					=	null;
		}

		if ( $event ) {

			// add substitutions for: [plan_id], [replaced_plan_id], [subscription_id], [parent_plan_id], [parent_subscription_id]
			$extraStringsLocal		=	array(	'plan_id'					=>	(int) $planId,
												'replaced_plan_id'			=>	(int) $replacedPlanId,
												'subscription_id'			=>	(int) $subscription->id,
												'parent_plan_id'			=>	(int) $subscription->parent_plan,
												'parent_subscription_id'	=>	(int) $subscription->parent_subscription
										);
			$extraStrings			=	array_merge( $subscription->substitutionStrings( false ), $extraStringsLocal );

			for ( $i = 1; $i <= 5; $i++ ) {
				$external			=	(int) $integrationParams->get( 'cpaycbsqlactions_type' . $i, 0 );

				if ( $external ) {
					$host			=	$integrationParams->get( 'cpaycbsqlactions_host' . $i, null );
					$usr			=	$integrationParams->get( 'cpaycbsqlactions_username' . $i, null );
					$pass			=	$integrationParams->get( 'cpaycbsqlactions_password' . $i, null );
					$db				=	$integrationParams->get( 'cpaycbsqlactions_database' . $i, null );
					$charset		=	$integrationParams->get( 'cpaycbsqlactions_charset' . $i, 'utf8' );
					$table_prefix	=	$integrationParams->get( 'cpaycbsqlactions_prefix' . $i, null );

					global $_CB_framework;

					$driver				=	$_CB_framework->getCfg( 'dbtype' );
					$options			=	array ( 'driver' => $driver, 'host' => $host, 'user' => $usr, 'password' => $pass, 'database' => $db, 'prefix' => $table_prefix );

					if ( is_callable( array( 'JDatabaseDriver', 'getInstance' ) ) ) {
						$_J_database	=&	\JDatabaseDriver::getInstance( $options );
					} else {
						$_J_database	=&	\JDatabase::getInstance( $options );
					}

					$SQL_database		=	new CmsDatabaseDriver( $_J_database, $table_prefix, checkJversion( 'release' ) );

					if ( $charset ) {
						$SQL_database->setQuery( 'SET NAMES ' . $SQL_database->Quote( $charset ) );
						$SQL_database->query();
					}
				} else {
					global $_CB_database;

					$SQL_database	=&	$_CB_database;
				}

				$query				=	trim( $integrationParams->get( 'cpaycbsqlactions_' . $event . $i, '' ) );

				if ( $query !== '' ) {
					$cbUser			=	CBuser::getInstance( $user->id );

					if ( ! $cbUser ) {
						return;
					}

					$queries		=	preg_split( '/(;\s*[\r\n])/', $query );

					$oldPwd							=	$user->password;
					$user->password					=	null;		// don't update cleartext password in case of registration
					$user->store();									// takes care of Mambo/Joomla ACL tables and many other stuff

					if ( $queries ) foreach ( $queries as $q ) {
						if ( $q ) {
							$SQL_database->setQuery( $cbUser->replaceUserVars( $q, array( $this, 'escapeSql' ), false, $extraStrings, false ) );
							$SQL_database->query();
						}
					}

					$user->load( $user->id );

					$user->password					=	$oldPwd;	// restore plaintext password if password was cleartext
				}
			}
		}
	}

	/**
	 * Sanitizes values from user data for SQL use by database-escaping it with backslashes
	 *
	 * @param  string  $v  User-provided value
	 * @return string      Database-safe value (at least when used in strings)
	 */
	public function escapeSql( $v ) {
		global $_CB_database;

		return $_CB_database->getEscaped( $v );
	}
}
