<?php
/**
* @version $Id: $
* @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
* @subpackage Template for Paid Subscriptions
* @copyright (C) 2007-2020 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Plugin\PlanOptions\Entity\OptionEntity;
use CB\Plugin\PlanOptions\Entity\PaidEntity;
use CB\Plugin\PlanOptions\Entity\ValueEntity;
use CB\Plugin\PlanOptions\Helper;
use CB\Plugin\PlanOptions\TemplateHandler;
use CBLib\Application\Application;
use CBLib\Language\CBTxt;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/** @noinspection AutoloadingIssuesInspection */
class cbpaidPlanOptionsView extends TemplateHandler
{
	/** @var string */
	public string $title						=	'';
	/** @var string */
	public string $description					=	'';
	/** @var OptionEntity[] */
	public array $options						=	[];
	/** @var ValueEntity[] */
	public array $values						=	[];
	/** @var PaidEntity[] */
	public array $paid							=	[];
	/** @var string */
	public string $url							=	'';
	/** @var string */
	public string $hidden						=	'';
	/** @var string */
	public string $price						=	'';
	/** @var string */
	public string $buttonSubmit					=	'';
	/** @var string */
	public string $buttonCancel					=	'';
	/** @var bool */
	public bool $toggle							=	false;
	/** @var null|cbpaidProduct */
	public ?cbpaidProduct $plan					=	null;
	/** @var null|cbpaidSomething */
	public ?cbpaidSomething $subscription		=	null;
	/** @var null|cbpaidPaymentBasket */
	public ?cbpaidPaymentBasket $paymentBasket	=	null;

	/**
	 * Returns the version of the implemented View
	 *
	 * @return int
	 */
	public function version(): int
	{
		return 1;
	}

	/**
	 * Draws the change options button
	 *
	 * @param cbpaidSomething $subscription
	 * @param bool            $changePrice
	 * @param bool            $changeOptions
	 * @return string
	 */
	public function drawButton( cbpaidSomething $subscription, bool $changePrice = true, bool $changeOptions = true ): string
	{
		global $_CB_framework;

		$this->plan			=	$subscription->getPlan();
		$this->subscription	=	$subscription;

		if ( $changePrice && $changeOptions ) {
			$this->buttonSubmit	=	CBTxt::Th( 'PLAN_OPTIONS_AND_PRICE_CHANGE', 'Change Pricing and Options' );
			$this->buttonCancel	=	CBTxt::Th( 'PLAN_OPTIONS_AND_PRICE_CANCEL_CHANGE', 'Cancel Change Pricing and Options' );
		} elseif ( $changePrice ) {
			$this->buttonSubmit	=	CBTxt::Th( 'PLAN_OPTIONS_PRICE_CHANGE', 'Change Pricing' );
			$this->buttonCancel	=	CBTxt::Th( 'PLAN_OPTIONS_PRICE_CANCEL_CHANGE', 'Cancel Change Pricing' );
		} else {
			$this->buttonSubmit	=	CBTxt::Th( 'PLAN_OPTIONS_CHANGE', 'Change Options' );
			$this->buttonCancel	=	CBTxt::Th( 'PLAN_OPTIONS_CANCEL_CHANGE', 'Cancel Change Options' );
		}

		$baseClass			=	cbpaidApp::getBaseClass();
		$this->url			=	$_CB_framework->pluginClassUrl( 'cbpaidsubscriptions', true, [	$baseClass->_getPagingParamName( 'act' )	=>	'cbsubsclass',
																								$baseClass->_getPagingParamName( 'class' )	=>	'options',
																								'do'										=>	'form',
																								'plan'										=>	$subscription->getPlan()->getInt( 'id', 0 ),
																								'sub'										=>	$subscription->getInt( 'id', 0 ),
																								cbSpoofField()								=>	cbSpoofString( null, 'cbsubsoptions' ),
																							], 'raw', 0, true );

		$_CB_framework->document->addHeadScriptUrl( '/components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/plugin/cbsubsoptions/js/cbsubsoptions.js', true );

		$this->outputTemplateCss( 'planoptions' );

		return $this->display( 'button' );
	}

	/**
	 * Draws the price selection and options form inputs
	 *
	 * @param cbpaidProduct        $plan
	 * @param null|cbpaidSomething $subscription
	 * @param bool                 $displayPrice
	 * @return string
	 */
	public function drawForm( cbpaidProduct $plan, ?cbpaidSomething $subscription = null, bool &$displayPrice = true ): string
	{
		global $_CB_framework;

		$prices					=	Helper::renderPlanPrices( $plan, $subscription );

		if ( $prices ) {
			$displayPrice		=	false;
		}

		$options				=	Helper::getPlanOptions( $plan, $subscription );

		if ( ( ! $prices ) && ( ! $options ) ) {
			return '';
		}

		if ( $subscription ) {
			$this->description	=	$subscription->getPersonalized( $plan->getParam( 'options_description_upgrade', '', 'integrations' ), true, true, null, false );
		} else {
			$this->description	=	$plan->getPersonalized( $plan->getParam( 'options_description', '', 'integrations' ), Application::MyUser()->getUserId(), true, true, null, false );
		}

		$this->options			=	$options;
		$this->price			=	$prices;
		$this->plan				=	$plan;
		$this->subscription		=	$subscription;

		if ( $this->options ) {
			$this->toggle		=	(bool) $plan->getParam( 'options_hide', false, 'integrations' );
			$this->hidden		=	'<input type="hidden" name="changeplanoptions[' . $plan->getInt( 'id', 0 ) . ']" value="1" class="cbsubsPlanOptionsInput cbsubsPlanOptionsAvailable" />';

			$baseClass			=	cbpaidApp::getBaseClass();
			$this->url			=	$_CB_framework->pluginClassUrl( 'cbpaidsubscriptions', true, [	$baseClass->_getPagingParamName( 'act' )	=>	'cbsubsclass',
																									$baseClass->_getPagingParamName( 'class' )	=>	'options',
																									'do'										=>	'price',
																									'plan'										=>	$plan->getInt( 'id', 0 ),
																									'sub'										=>	( $subscription ? $subscription->getInt( 'id', 0 ) : null ),
																									cbSpoofField()								=>	cbSpoofString( null, 'cbsubsoptions' ),
																								], 'raw', 0, true );
		}

		$_CB_framework->document->addHeadScriptUrl( '/components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/plugin/cbsubsoptions/js/cbsubsoptions.js', true );

		$this->outputTemplateCss( 'planoptions' );

		$form					=	$this->display( 'form' );

		$plan->set( '_displayPeriodPriceRecursionsLimiter', 1 );

		if ( $subscription ) {
			$subscription->set( '_displayPeriodPriceRecursionsLimiter', 1 );
		}

		return $form;
	}

	/**
	 * Draws the stored options display for a subscription
	 *
	 * @param cbpaidProduct   $plan
	 * @param cbpaidSomething $subscription
	 * @return string
	 */
	public function drawDisplay( cbpaidProduct $plan, cbpaidSomething $subscription ): string
	{
		$values					=	Helper::getSelectedValues( $plan, $subscription, Helper::getSelectedPlanPrice( $plan, $subscription ) );

		if ( ! $values ) {
			return '';
		}

		$this->description		=	$subscription->getPersonalized( $plan->getParam( 'options_description_subscriptions', '', 'integrations' ), true, true, null, false );
		$this->values			=	$values;
		$this->plan				=	$plan;
		$this->subscription		=	$subscription;

		$this->outputTemplateCss( 'planoptions' );

		$display				=	$this->display( 'display' );

		$plan->set( '_displayPeriodPriceRecursionsLimiter', 1 );
		$subscription->set( '_displayPeriodPriceRecursionsLimiter', 1 );

		return $display;
	}

	/**
	 * @param cbpaidSomething     $subscription
	 * @param cbpaidPaymentBasket $paymentBasket
	 * @return string
	 */
	public function drawBasket( cbpaidSomething $subscription, cbpaidPaymentBasket $paymentBasket ): string
	{
		if ( $paymentBasket->getString( 'proformainvoice', '' ) ) {
			$values				=	Helper::getPaidBasketValues( $paymentBasket, $subscription );
		} else {
			$values				=	Helper::getBasketValues( $paymentBasket, $subscription, Helper::getBasketPlanPrice( $paymentBasket, $subscription ) );
		}

		if ( ! $values ) {
			return '';
		}

		$this->plan				=	$subscription->getPlan();
		$this->subscription		=	$subscription;
		$this->paymentBasket	=	$paymentBasket;

		$this->outputTemplateCss( 'planoptions' );

		if ( $paymentBasket->getString( 'proformainvoice', '' ) ) {
			$this->paid			=	$values;

			return $this->display( 'invoice' );
		}

		$this->values			=	$values;

		return $this->display( 'basket' );
	}
}
