<?php
/**
* @version $Id: $
* @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
* @subpackage Template for Paid Subscriptions
* @copyright (C) 2007-2020 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

$tmplVersion	=	1;	// This is the template version that needs to match

/**
 * @var cbpaidPlanOptionsView $this
 */
?>
<div class="d-flex flex-column cbsubsInvoicePlanOptionsValues">
	<?php foreach ( $this->paid as $value ) { ?>
		<div class="d-flex text-small cbsubsInvoicePlanOptionsValue">
			<span class="fa fa-level-up fa-rotate-90"></span>
			<?php echo CBTxt::T( 'PLAN_OPTIONS_INVOICE', '[option]: [label] – [price]', [ '[option]' => $value->getTitle(), '[label]' => $value->getLabel(), '[price]' => $value->renderPrice() ] ); ?>
		</div>
	<?php } ?>
</div>