<?php
/**
* @version $Id: $
* @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
* @subpackage Template for Paid Subscriptions
* @copyright (C) 2007-2020 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

$tmplVersion	=	1;	// This is the template version that needs to match

/**
 * @var cbpaidPlanOptionsView $this
 */
?>
<div class="<?php echo ( $this->subscription ? 'mb-1 ' : '' ); ?>d-flex flex-column cbsubsPlanOptions<?php echo ( $this->toggle && ( ! $this->price ) ? ' cbsubsPlanOptionsToggle hidden' : '' ); ?>"<?php echo ( $this->options ? 'data-url="' . $this->url . '"' : '' ); ?>>
	<?php if ( $this->description ) { ?>
	<div class="cbsubsPlanOptionsDesc">
		<?php echo $this->description; ?>
	</div>
	<?php } ?>
	<?php if ( $this->options ) { ?>
	<div class="d-flex flex-column cbsubsPlanOptionsSelection<?php echo ( $this->toggle && $this->price ? ' cbsubsPlanOptionsToggle hidden' : '' ); ?>">
		<?php foreach ( $this->options as $option ) {
			switch ( $option->getDisplay() ) {
				case 5: // Inline
					?>
						<div class="d-flex cbft_select cbtt_select cb_form_line cbsubsPlanOptionsField">
							<label for="<?php echo $option->getInputId(); ?>" class="col-form-label"><?php echo $option->getTitle(); ?></label>
							<div class="cb_field">
								<?php echo $option->renderInput(); ?>
							</div>
						</div>
					<?php
					break;
				case 4: // 1 Line without Title
					?>
						<div class="m-0 form-group row no-gutters cbft_select cbtt_select cb_form_line cbtwolinesfield cbsubsPlanOptionsField">
							<div class="cb_field col-sm-12">
								<?php echo $option->renderInput(); ?>
							</div>
						</div>
					<?php
					break;
				case 3: // 1 Line with Empty Title
					?>
						<div class="m-0 form-group row no-gutters cbft_select cbtt_select cb_form_line cbsubsPlanOptionsField">
							<div class="cb_field col-sm-9 offset-sm-3">
								<?php echo $option->renderInput(); ?>
							</div>
						</div>
					<?php
					break;
				case 2: // 2 Lines with Title
					?>
						<div class="m-0 form-group row no-gutters cbft_select cbtt_select cb_form_line cbtwolinesfield cbsubsPlanOptionsField">
							<label for="<?php echo $option->getInputId(); ?>" class="col-form-label col-sm-12"><?php echo $option->getTitle(); ?></label>
							<div class="cb_field col-sm-12">
								<?php echo $option->renderInput(); ?>
							</div>
						</div>
					<?php
					break;
				case 1: // 1 Line with Title
				default:
					?>
						<div class="m-0 form-group row no-gutters cbft_select cbtt_select cb_form_line cbsubsPlanOptionsField">
							<label for="<?php echo $option->getInputId(); ?>" class="col-form-label col-sm-3 pr-sm-2"><?php echo $option->getTitle(); ?></label>
							<div class="cb_field col-sm-9">
								<?php echo $option->renderInput(); ?>
							</div>
						</div>
					<?php
					break;
			}
		} ?>
		<?php echo $this->hidden; ?>
	</div>
	<?php } ?>
	<?php if ( $this->price ) { ?>
	<div class="cbsubsPlanOptionsPrice">
		<?php echo $this->price; ?>
	</div>
	<?php } ?>
</div>