<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2022 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\PlanOptions;

use CBLib\Application\Application;
use CBLib\Language\CBTxt;
use cbpaidPlansMgr;
use cbpaidProduct;
use cbpaidSomething;
use cbpaidSomethingMgr;
use cbTabHandler;

\defined( 'CBLIB') or die();

class Task extends cbTabHandler
{
	/**
	 * Performs component tasks through CBSubs component endpoint using a plugin
	 *
	 * @return null|string
	 */
	public function executeTask(): ?string
	{
		$token				=	$this->getInput()->getString( cbSpoofField(), '' );

		if ( ( ! $token ) || ( $token !== cbSpoofString( $token, 'cbsubsoptions' ) ) ) {
			header( 'HTTP/1.0 401 Unauthorized' );
			exit();
		}

		$do					=	$this->getInput()->getString( 'do' );

		if ( ! \in_array( $do, [ 'form', 'price' ], true ) ) {
			header( 'HTTP/1.0 401 Unauthorized' );
			exit();
		}

		$planId				=	$this->getInput()->getInt( 'plan', 0 );
		$subscriptionId		=	$this->getInput()->getInt( 'sub', 0 );
		$subscription		=	null;

		if ( $subscriptionId ) {
			$subscription	=	cbpaidSomethingMgr::getInstance()->loadSomething( $planId, $subscriptionId );

			if ( ! $subscription ) {
				header( 'HTTP/1.0 401 Unauthorized' );
				exit();
			}

			$plan			=	$subscription->getPlan();
		} elseif ( $planId ) {
			$plan			=	cbpaidPlansMgr::getInstance()->loadPlan( $planId );

			if ( ! $plan ) {
				header( 'HTTP/1.0 401 Unauthorized' );
				exit();
			}
		} else {
			header( 'HTTP/1.0 401 Unauthorized' );
			exit();
		}

		header( 'HTTP/1.0 200 OK' );

		if ( $do === 'form' ) {
			if ( ! $subscription ) {
				header( 'HTTP/1.0 401 Unauthorized' );
				exit();
			}

			$this->renderForm( $plan, $subscription );
		} else {
			$this->renderPrice( $plan, $subscription );
		}

		exit();
	}

	/**
	 * @param cbpaidProduct        $plan
	 * @param null|cbpaidSomething $subscription
	 * @return void
	 */
	private function renderPrice( cbpaidProduct $plan, ?cbpaidSomething $subscription = null ): void
	{
		global $_CB_framework;

		$prices						=	'';

		if ( Helper::hasPlanPrices( $plan ) ) {
			$prices					=	Helper::renderPlanPrices( $plan, $subscription, Application::Input()->getString( 'planprices.' . $plan->getInt( 'id', 0 ), '' ) );
		}

		if ( ! $prices ) {
			Helper::setBasePlanPrice( $plan, $subscription );

			$selected				=	Helper::getSelectedPlanPrice( $plan, $subscription );

			if ( $selected ) {
				Helper::setPlanOverrides( $plan, $selected );
			}

			Helper::setPlanOverrides( $plan, Helper::getSelectedPrice( $plan, $subscription, $selected ) );
		}

		$myId						=	Application::MyUser()->getUserId();

		if ( $subscription ) {
			if ( $prices ) {
				switch ( $subscription->realStatus( $_CB_framework->now() ) ) {
					case 'X':
						echo $plan->buttonText( 'reactivate' );
						break;
					case 'C':
						echo $plan->buttonText( 'resubscribe' );
						break;
					default:
						echo $plan->buttonText( 'renew' );
						break;
				}

				echo '<div class="cbsubsPlanOptionsPrice">' . $prices . '</div>';
			} else {
				$status				=	$subscription->realStatus( $_CB_framework->now() );

				if ( $status === 'C' ) {
					$periodPrice	=	$subscription->displayPeriodPrice( 'N' );
				} else {
					$periodPrice	=	$subscription->displayPeriodPrice( 'R' );
				}

				$separator			=	( ( $periodPrice && ( trim( str_replace( '&nbsp;', '', $periodPrice ) ) ) ) ? ': ' : '' );

				switch ( $status ) {
					case 'X':
						echo CBTxt::Th( 'PLAN_RENEW_BUTTON REACTIVATE_PLAN_BUTTON', '[button_text][separator][period_price]', [ '[button_text]' => $plan->buttonText( 'reactivate' ), '[separator]' => $separator, '[period_price]' => $periodPrice ] );
						break;
					case 'C':
						echo CBTxt::Th( 'PLAN_RENEW_BUTTON RESUBSCRIBE_PLAN_BUTTON', '[button_text][separator][period_price]', [ '[button_text]' => $plan->buttonText( 'resubscribe' ), '[separator]' => $separator, '[period_price]' => $periodPrice ] );
						break;
					default:
						echo CBTxt::Th( 'PLAN_RENEW_BUTTON RENEW_PLAN_BUTTON', '[button_text][separator][period_price]', [ '[button_text]' => $plan->buttonText( 'renew' ), '[separator]' => $separator, '[period_price]' => $periodPrice ] );
						break;
				}
			}
		} elseif ( $prices ) {
			echo $prices;
		} else {
			echo $plan->displayPeriodPrice( $myId, ( $myId ? 'U' : 'N' ) );
		}
	}

	/**
	 * @param cbpaidProduct        $plan
	 * @param null|cbpaidSomething $subscription
	 * @return void
	 */
	private function renderForm( cbpaidProduct $plan, cbpaidSomething $subscription ): void
	{
		/** @var $viewer \cbpaidPlanOptionsView */
		$viewer		=	TemplateHandler::getViewer( null, 'planoptions' );

		echo $viewer->drawForm( $plan, $subscription );
	}
}
