<?php
/**
* CBSubs (TM): Community Builder Paid Subscriptions Plugin: cbsubsgroupjive
* @version $Id: cbsubs.groupjive.php 1465 2012-07-10 17:37:13Z beat $
* @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
* @subpackage cbsubs.groupjive.php
* @author Beat
* @copyright (C) 2007-2022 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CBLib\Application\Application;
use CBLib\Registry\ParamsInterface;
use CBLib\Registry\GetterInterface;
use CB\Plugin\GroupJive\CBGroupJive;
use CB\Plugin\GroupJive\Table\CategoryTable;
use CB\Plugin\GroupJive\Table\GroupTable;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_PLUGINS;

$_PLUGINS->registerFunction( 'onCPayUserStateChange', 'onCPayUserStateChange', 'getcbsubsgroupjiveTab' );

/**
 * CBSubs GroupJive integration plugin class
 */
class getcbsubsgroupjiveTab extends cbTabHandler
{

	/**
	 * Called at each change of user subscription state due to a plan activation or deactivation
	 *
	 * @param  UserTable        $user
	 * @param  string           $status
	 * @param  int              $planId
	 * @param  int              $replacedPlanId
	 * @param  ParamsInterface  $integrationParams
	 * @param  string           $cause              'PaidSubscription' (first activation only), 'SubscriptionActivated' (renewals, cancellation reversals), 'SubscriptionDeactivated', 'Denied'
	 * @param  string           $reason             'N' new subscription, 'R' renewal, 'U'=update )
	 * @param  int              $now                Unix time
	 */
	public function onCPayUserStateChange( &$user, $status, /** @noinspection PhpUnusedParameterInspection */ $planId, /** @noinspection PhpUnusedParameterInspection */ $replacedPlanId, &$integrationParams, $cause, /** @noinspection PhpUnusedParameterInspection */ $reason, /** @noinspection PhpUnusedParameterInspection */ $now )
	{
		global $_CB_framework;

		if ( ! is_object( $user ) ) {
			return;
		}

		$api	=	$_CB_framework->getCfg( 'absolute_path' ) . '/components/com_comprofiler/plugin/user/plug_cbgroupjive/cbgroupjive.class.php';

		if ( file_exists( $api ) ) {
			/** @noinspection PhpIncludeInspection */
			require_once( $api );

			$this->groupjive2( $user, $status, $cause, $integrationParams );
		} elseif ( file_exists( $_CB_framework->getCfg( 'absolute_path' ) . '/components/com_comprofiler/plugin/user/plug_cbgroupjive/xml/metadata.xml' ) ) {
			$this->groupjive3( $user, $status, $cause, $integrationParams );
		}
	}

	/**
	 * Executes CB GroupJive 2.x usage
	 *
	 * @param  UserTable        $user
	 * @param  string           $status
	 * @param  string           $cause
	 * @param  ParamsInterface  $integrationParams
	 */
	public function groupjive2( &$user, $status, $cause, &$integrationParams )
	{
		$gj_plugin										=	cbgjClass::getPlugin();
		$cbUser											=	CBuser::getInstance( $user->id, false );

		for ( $i = 1; $i <= 5; $i++ ) {
			if ( ( $status === 'A' ) && ( $cause === 'PaidSubscription' ) ) {
				if ( ( cbgjClass::getCleanParam( true, 'cbgj_auto_type' . $i, null, null, $integrationParams ) == 3 ) && cbgjClass::getCleanParam( true, 'cbgj_auto_name' . $i, null, null, $integrationParams ) ) {
					$parent								=	(int) cbgjClass::getCleanParam( true, 'cbgj_auto_cat_parent' . $i, '0', null, $integrationParams );
					$name								=	$cbUser->replaceUserVars( cbgjClass::getCleanParam( true, 'cbgj_auto_name' . $i, null, null, $integrationParams ) );

					if ( cbgjClass::getCleanParam( true, 'cbgj_auto_unique' . $i, 1, null, $integrationParams ) ) {
						$where							=	array( array( 'user_id', '=', $user->id ), array( 'name', '=', $name ), array( 'parent', '=', $parent ) );
					} else {
						$where							=	array( array( 'name', '=', $name ), array( 'parent', '=', $parent ) );
					}

					$row								=	cbgjData::getCategories( null, null, $where, null, null, false );

					if ( ! $row->id ) {
						$category_editor				=	$gj_plugin->params->get( 'category_editor', 1 );
						$types							=	cbgjClass::getCleanParam( true, 'cbgj_auto_cat_types' . $i, '1|*|2|*|3', null, $integrationParams );

						$row->published					=	1;
						$row->parent					=	$parent;
						$row->user_id					=	(int) $user->id;
						$row->name						=	$name;

						if ( ( $category_editor == 2 ) || ( $category_editor == 3 ) ) {
							$row->description			=	$cbUser->replaceUserVars( cbgjClass::getHTMLCleanParam( true, 'cbgj_auto_desc' . $i, null, null, $integrationParams ) );
						} else {
							$row->description			=	$cbUser->replaceUserVars( cbgjClass::getCleanParam( true, 'cbgj_auto_desc' . $i, null, null, $integrationParams ) );
						}

						$row->access					=	(int) $gj_plugin->params->get( 'category_access_default', -2 );
						$row->types						=	( $types ? $types : $gj_plugin->params->get( 'category_types_default', '1|*|2|*|3' ) );
						$row->create					=	(int) $gj_plugin->params->get( 'category_create_default', 1 );
						$row->create_access				=	(int) $gj_plugin->params->get( 'category_createaccess_default', -1 );
						$row->nested					=	(int) $gj_plugin->params->get( 'category_nested_default', 1 );
						$row->nested_access				=	(int) $gj_plugin->params->get( 'category_nestedaccess_default', -1 );
						$row->date						=	Application::Database()->getUtcDateTime();
						$row->ordering					=	99999;

						$row->store();
					}
				} elseif ( ( cbgjClass::getCleanParam( true, 'cbgj_auto_type' . $i, null, null, $integrationParams ) == 2 ) && cbgjClass::getCleanParam( true, 'cbgj_auto_grp_cat' . $i, null, null, $integrationParams ) && cbgjClass::getCleanParam( true, 'cbgj_auto_name' . $i, null, null, $integrationParams ) ) {
					if ( ( cbgjClass::getCleanParam( true, 'cbgj_auto_grp_cat' . $i, null, null, $integrationParams ) == -1 ) && cbgjClass::getCleanParam( true, 'cbgj_auto_grp_cat_name' . $i, null, null, $integrationParams ) ) {
						$parent							=	(int) cbgjClass::getCleanParam( true, 'cbgj_auto_grp_cat_parent' . $i, '0', null, $integrationParams );
						$name							=	$cbUser->replaceUserVars( cbgjClass::getCleanParam( true, 'cbgj_auto_grp_cat_name' . $i, null, null, $integrationParams ) );

						if ( cbgjClass::getCleanParam( true, 'cbgj_auto_grp_cat_unique' . $i, 1, null, $integrationParams ) ) {
							$where						=	array( array( 'user_id', '=', $user->id ), array( 'name', '=', $name ), array( 'parent', '=', $parent ) );
						} else {
							$where						=	array( array( 'name', '=', $name ), array( 'parent', '=', $parent ) );
						}

						$category						=	cbgjData::getCategories( null, null, $where, null, null, false );

						if ( ! $category->id ) {
							$category_editor			=	$gj_plugin->params->get( 'category_editor', 1 );
							$types						=	cbgjClass::getCleanParam( true, 'cbgj_auto_grp_cat_types' . $i, '1|*|2|*|3', null, $integrationParams );

							$category->published		=	1;
							$category->parent			=	$parent;
							$category->user_id			=	(int) $user->id;
							$category->name				=	$name;

							if ( ( $category_editor == 2 ) || ( $category_editor == 3 ) ) {
								$category->description	=	$cbUser->replaceUserVars( cbgjClass::getHTMLCleanParam( true, 'cbgj_auto_grp_cat_desc' . $i, null, null, $integrationParams ) );
							} else {
								$category->description	=	$cbUser->replaceUserVars( cbgjClass::getCleanParam( true, 'cbgj_auto_grp_cat_desc' . $i, null, null, $integrationParams ) );
							}

							$category->access			=	(int) $gj_plugin->params->get( 'category_access_default', -2 );
							$category->types			=	( $types ? $types : $gj_plugin->params->get( 'category_types_default', '1|*|2|*|3' ) );
							$category->create			=	(int) $gj_plugin->params->get( 'category_create_default', 1 );
							$category->create_access	=	(int) $gj_plugin->params->get( 'category_createaccess_default', -1 );
							$category->nested			=	(int) $gj_plugin->params->get( 'category_nested_default', 1 );
							$category->nested_access	=	(int) $gj_plugin->params->get( 'category_nestedaccess_default', -1 );
							$category->date				=	Application::Database()->getUtcDateTime();
							$category->ordering			=	99999;

							$category->store();
						}
					} else {
						$category						=	cbgjData::getCategories( null, null, array( 'id', '=', cbgjClass::getCleanParam( true, 'cbgj_auto_grp_cat' . $i, null, null, $integrationParams ) ), null, null, false );
					}

					if ( $category->id ) {
						$parent							=	(int) cbgjClass::getCleanParam( true, 'cbgj_auto_grp_parent' . $i, '0', null, $integrationParams );
						$name							=	$cbUser->replaceUserVars( cbgjClass::getCleanParam( true, 'cbgj_auto_name' . $i, null, null, $integrationParams ) );
						$join							=	false;

						if ( cbgjClass::getCleanParam( true, 'cbgj_auto_unique' . $i, 1, null, $integrationParams ) ) {
							$where						=	array( array( 'category', '=', $category->id ), array( 'user_id', '=', $user->id ), array( 'name', '=', $name ), array( 'parent', '=', $parent ) );
						} else {
							$where						=	array( array( 'category', '=', $category->id ), array( 'name', '=', $name ), array( 'parent', '=', $parent ) );

							if ( cbgjClass::getCleanParam( true, 'cbgj_auto_grp_autojoin' . $i, 1, null, $integrationParams ) ) {
								$join					=	true;
							}
						}

						$row							=	cbgjData::getGroups( null, null, $where, null, null, false );

						if ( ! $row->id ) {
							$group_editor				=	$gj_plugin->params->get( 'group_editor', 1 );
							$type						=	cbgjClass::getCleanParam( true, 'cbgj_auto_grp_type' . $i, 1, null, $integrationParams );

							$row->published				=	1;
							$row->category				=	(int) $category->id;
							$row->parent				=	$parent;
							$row->user_id				=	(int) $user->id;
							$row->name					=	$name;

							if ( ( $group_editor == 2 ) || ( $group_editor == 3 ) ) {
								$row->description		=	$cbUser->replaceUserVars( cbgjClass::getHTMLCleanParam( true, 'cbgj_auto_desc' . $i, null, null, $integrationParams ) );
							} else {
								$row->description		=	$cbUser->replaceUserVars( cbgjClass::getCleanParam( true, 'cbgj_auto_desc' . $i, null, null, $integrationParams ) );
							}

							$row->access				=	(int) $gj_plugin->params->get( 'group_access_default', -2 );
							$row->type					=	(int) ( $type ? $type : $gj_plugin->params->get( 'group_type_default', 1 ) );
							$row->nested				=	(int) $gj_plugin->params->get( 'group_nested_default', 1 );
							$row->nested_access			=	(int) $gj_plugin->params->get( 'group_nestedaccess_default', -1 );
							$row->date					=	Application::Database()->getUtcDateTime();
							$row->ordering				=	1;

							if ( $row->store() ) {
								$row->storeOwner( $row->user_id );
							}
						} elseif ( $join ) {
							$usr						=	cbgjData::getUsers( null, null, array( array( 'group', '=', $row->id ), array( 'user_id', '=', $user->id ) ), null, null, false );

							if ( ! $usr->id ) {
								$usr->user_id			=	(int) $user->id;
								$usr->group				=	(int) $row->id;
								$usr->date				=	Application::Database()->getUtcDateTime();
								$usr->status			=	(int) cbgjClass::getCleanParam( true, 'cbgj_auto_grp_usr_status' . $i, 1, null, $integrationParams );

								if ( $usr->store() ) {
									if ( $usr->status == 4 ) {
										$row->storeOwner( $usr->user_id );
									}
								}
							}
						}
					}
				} elseif ( ( cbgjClass::getCleanParam( true, 'cbgj_auto_type' . $i, null, null, $integrationParams ) == 1 ) && cbgjClass::getCleanParam( true, 'cbgj_auto_usr_groups' . $i, null, null, $integrationParams ) ) {
					$groups								=	cbgjClass::getCleanParam( true, 'cbgj_auto_usr_groups' . $i, null, null, $integrationParams );

					if ( $groups ) {
						$groups							=	explode( '|*|', $groups );

						cbArrayToInts( $groups );
					}

					if ( $groups ) foreach ( $groups as $group_id ) {
						$group							=	cbgjData::getGroups( null, null, array( 'id', '=', $group_id ), null, null, false );

						if ( $group->id ) {
							$row						=	cbgjData::getUsers( null, null, array( array( 'group', '=', $group->id ), array( 'user_id', '=', $user->id ) ), null, null, false );

							if ( ! $row->id ) {
								$row->user_id			=	(int) $user->id;
								$row->group				=	(int) $group->id;
								$row->date				=	Application::Database()->getUtcDateTime();
								$row->status			=	(int) cbgjClass::getCleanParam( true, 'cbgj_auto_usr_status' . $i, 1, null, $integrationParams );

								if ( $row->store() ) {
									if ( $row->status == 4 ) {
										$group->storeOwner( $row->user_id);
									}
								}
							}
						}
					}
				}
			} elseif ( in_array( $status, array( 'X', 'C' ), true )
					   && ( $cause !== 'Pending' )
					   && cbgjClass::getCleanParam( true, 'cbgj_auto_remove' . $i, null, null, $integrationParams )
			) {
				if ( ( cbgjClass::getCleanParam( true, 'cbgj_auto_type' . $i, null, null, $integrationParams ) == 3 ) && cbgjClass::getCleanParam( true, 'cbgj_auto_name' . $i, null, null, $integrationParams ) ) {
					$name								=	$cbUser->replaceUserVars( cbgjClass::getCleanParam( true, 'cbgj_auto_name' . $i, null, null, $integrationParams ) );

					if ( cbgjClass::getCleanParam( true, 'cbgj_auto_unique' . $i, 1, null, $integrationParams ) ) {
						$where							=	array( array( 'user_id', '=', $user->id ), array( 'name', '=', $name ) );
					} else {
						$where							=	array( 'name', '=', $name );
					}

					$row								=	cbgjData::getCategories( null, null, $where, null, null, false );

					if ( $row->id ) {
						$row->deleteAll();
					}
				} elseif ( ( cbgjClass::getCleanParam( true, 'cbgj_auto_type' . $i, null, null, $integrationParams ) == 2 ) && cbgjClass::getCleanParam( true, 'cbgj_auto_grp_cat' . $i, null, null, $integrationParams ) && cbgjClass::getCleanParam( true, 'cbgj_auto_name' . $i, null, null, $integrationParams ) ) {
					$name								=	$cbUser->replaceUserVars( cbgjClass::getCleanParam( true, 'cbgj_auto_name' . $i, null, null, $integrationParams ) );

					if ( cbgjClass::getCleanParam( true, 'cbgj_auto_grp_cat' . $i, null, null, $integrationParams ) == -1 ) {
						if ( cbgjClass::getCleanParam( true, 'cbgj_auto_grp_cat_unique' . $i, 1, null, $integrationParams ) ) {
							$where						=	array( array( 'user_id', '=', $user->id ), array( 'name', '=', $name ) );
						} else {
							$where						=	array( 'name', '=', $name );
						}
					} else {
						$category						=	cbgjData::getCategories( null, null, array( 'id', '=', cbgjClass::getCleanParam( true, 'cbgj_auto_grp_cat' . $i, null, null, $integrationParams ) ), null, null, false );

						if ( cbgjClass::getCleanParam( true, 'cbgj_auto_unique' . $i, 1, null, $integrationParams ) ) {
							$where						=	array( array( 'category', '=', $category->id ), array( 'user_id', '=', $user->id ), array( 'name', '=', $name ) );
						} else {
							$where						=	array( array( 'category', '=', $category->id ), array( 'name', '=', $name ) );
						}
					}

					$row								=	cbgjData::getGroups( null, null, $where, null, null, false );

					if ( $row->id ) {
						$row->deleteAll();
					}
				} elseif ( ( cbgjClass::getCleanParam( true, 'cbgj_auto_type' . $i, null, null, $integrationParams ) == 1 ) && cbgjClass::getCleanParam( true, 'cbgj_auto_usr_groups' . $i, null, null, $integrationParams ) ) {
					$groups								=	cbgjClass::getCleanParam( true, 'cbgj_auto_usr_groups' . $i, null, null, $integrationParams );

					if ( $groups ) {
						$groups							=	explode( '|*|', $groups );

						cbArrayToInts( $groups );
					}

					if ( $groups ) foreach ( $groups as $group_id ) {
						$group							=	cbgjData::getGroups( null, null, array( 'id', '=', $group_id ), null, null, false );

						if ( $group->id ) {
							$row						=	cbgjData::getUsers( null, null, array( array( 'group', '=', $group->id ), array( 'user_id', '=', $user->id ) ), null, null, false );

							if ( $row->id ) {
								$row->deleteAll();
							}
						}
					}
				}
			}
		}
	}

	/**
	 * Executes CB GroupJive 3.x usage
	 *
	 * @param  UserTable        $user
	 * @param  string           $status
	 * @param  string           $cause
	 * @param  ParamsInterface  $integrationParams
	 */
	public function groupjive3( &$user, $status, $cause, &$integrationParams )
	{
		global $_CB_database;

		$cbUser											=	CBuser::getInstance( (int) $user->get( 'id' ), false );

		for ( $i = 1; $i <= 5; $i++ ) {
			if ( ( $status === 'A' ) && ( $cause === 'PaidSubscription' ) ) {
				switch( (int) $integrationParams->get( 'cbgj_auto_type' . $i, 1, GetterInterface::INT ) ) {
					case 3:
						$name							=	$cbUser->replaceUserVars( $integrationParams->get( 'cbgj_auto_name' . $i, null, GetterInterface::STRING ) );

						if ( ! $name ) {
							continue 2;
						}

						$category						=	new CategoryTable();

						$category->load( array( 'name' => $name ) );

						if ( $category->get( 'id' ) ) {
							continue 2;
						}

						$category->set( 'published', 1 );
						$category->set( 'name', $name );
						$category->set( 'description', $cbUser->replaceUserVars( $integrationParams->get( 'cbgj_auto_desc' . $i, null, GetterInterface::STRING ) ) );
						$category->set( 'access', 1 );
						$category->set( 'create_access', 0 );
						$category->set( 'types', $integrationParams->get( 'cbgj_auto_cat_types' . $i, '1|*|2|*|3', GetterInterface::STRING ) );
						$category->set( 'ordering', 1 );

						$category->store();
						break;
					case 2:
						$categoryId						=	(int) $integrationParams->get( 'cbgj_auto_grp_cat' . $i, -1, GetterInterface::INT );

						$category						=	new CategoryTable();

						if ( $categoryId == -1 ) {
							$name						=	$cbUser->replaceUserVars( $integrationParams->get( 'cbgj_auto_grp_cat_name' . $i, null, GetterInterface::STRING ) );

							if ( ! $name ) {
								continue 2;
							}

							$category->load( array( 'name' => $name ) );

							if ( ! $category->get( 'id' ) ) {
								$category->set( 'published', 1 );
								$category->set( 'name', $name );
								$category->set( 'description', $cbUser->replaceUserVars( $integrationParams->get( 'cbgj_auto_grp_cat_desc' . $i, null, GetterInterface::STRING ) ) );
								$category->set( 'access', 1 );
								$category->set( 'create_access', 0 );
								$category->set( 'types', $integrationParams->get( 'cbgj_auto_grp_cat_types' . $i, '1|*|2|*|3', GetterInterface::STRING ) );
								$category->set( 'ordering', 1 );

								if ( ! $category->store() ) {
									continue 2;
								}
							}
						} else {
							$category->load( (int) $categoryId );
						}

						if ( ! $category->get( 'id' ) ) {
							continue 2;
						}

						$name							=	$cbUser->replaceUserVars( $integrationParams->get( 'cbgj_auto_name' . $i, null, GetterInterface::STRING ) );

						if ( ! $name ) {
							continue 2;
						}

						$group							=	new GroupTable();
						$join							=	false;

						if ( $integrationParams->get( 'cbgj_auto_unique' . $i, 1, GetterInterface::BOOLEAN ) ) {
							$group->load( array( 'category' => (int) $category->get( 'id' ), 'user_id' => (int) $user->get( 'id' ), 'name' => $name ) );
						} else {
							$group->load( array( 'category' => (int) $category->get( 'id' ), 'name' => $name ) );

							if ( $integrationParams->get( 'cbgj_auto_grp_autojoin' . $i, 1, GetterInterface::BOOLEAN ) ) {
								$join					=	true;
							}
						}

						if ( ! $group->get( 'id' ) ) {
							$group->set( 'published', 1 );
							$group->set( 'category', (int) $category->get( 'id' ) );
							$group->set( 'user_id', (int) $user->get( 'id' ) );
							$group->set( 'name', $name );
							$group->set( 'description', $cbUser->replaceUserVars( $integrationParams->get( 'cbgj_auto_desc' . $i, null, GetterInterface::STRING ) ) );
							$group->set( 'type', (int) $integrationParams->get( 'cbgj_auto_grp_type' . $i, 1, GetterInterface::INT ) );
							$group->set( 'ordering', 1 );

							if ( ! $group->store() ) {
								continue 2;
							}
						} elseif ( $join ) {
							$groupUser					=	new \CB\Plugin\GroupJive\Table\UserTable( $_CB_database );

							$groupUser->load( array( 'group' => (int) $group->get( 'id' ), 'user_id' => (int) $user->get( 'id' ) ) );

							if ( $groupUser->get( 'id' ) ) {
								continue 2;
							}

							$groupUser->set( 'user_id', (int) $user->get( 'id' ) );
							$groupUser->set( 'group', (int) $group->get( 'id' ) );
							$groupUser->set( 'status', (int) $integrationParams->get( 'cbgj_auto_grp_usr_status' . $i, 1, GetterInterface::INT ) );

							if ( ! $groupUser->store() ) {
								continue 2;
							}
						}
						break;
					case 1:
						$groups							=	$integrationParams->get( 'cbgj_auto_usr_groups' . $i, null, GetterInterface::STRING );

						if ( ! $groups ) {
							continue 2;
						}

						$groups							=	explode( '|*|', $groups );

						cbArrayToInts( $groups );

						foreach ( $groups as $groupId ) {
							$group						=	new GroupTable();

							$group->load( (int) $groupId );

							if ( ! $group->get( 'id' ) ) {
								continue;
							}

							$groupUser					=	new \CB\Plugin\GroupJive\Table\UserTable( $_CB_database );

							$groupUser->load( array( 'group' => (int) $group->get( 'id' ), 'user_id' => (int) $user->get( 'id' ) ) );

							if ( $groupUser->get( 'id' ) ) {
								continue;
							}

							$groupUser->set( 'user_id', (int) $user->get( 'id' ) );
							$groupUser->set( 'group', (int) $group->get( 'id' ) );
							$groupUser->set( 'status', (int) $integrationParams->get( 'cbgj_auto_usr_status' . $i, 1, GetterInterface::INT ) );

							if ( ! $groupUser->store() ) {
								continue;
							}
						}
						break;
				}
			} elseif ( in_array( $status, array( 'X', 'C' ), true )
					   && ( $cause !== 'Pending' )
					   && $integrationParams->getInt( 'cbgj_auto_remove' . $i, 0 )
			) {
				switch( (int) $integrationParams->get( 'cbgj_auto_type' . $i, 1, GetterInterface::INT ) ) {
					case 3:
						$name							=	$cbUser->replaceUserVars( $integrationParams->get( 'cbgj_auto_name' . $i, null, GetterInterface::STRING ) );

						if ( ! $name ) {
							continue 2;
						}

						$category						=	new CategoryTable();

						$category->load( array( 'name' => $name ) );

						if ( ! $category->get( 'id' ) ) {
							continue 2;
						}

						$category->delete();
						break;
					case 2:
						$categoryId						=	(int) $integrationParams->get( 'cbgj_auto_grp_cat' . $i, -1, GetterInterface::INT );

						$category						=	new CategoryTable();

						if ( $categoryId == -1 ) {
							$name						=	$cbUser->replaceUserVars( $integrationParams->get( 'cbgj_auto_grp_cat_name' . $i, null, GetterInterface::STRING ) );

							if ( ! $name ) {
								continue 2;
							}

							$category->load( array( 'name' => $name ) );
						} else {
							$category->load( (int) $categoryId );
						}

						if ( ! $category->get( 'id' ) ) {
							continue 2;
						}

						$name							=	$cbUser->replaceUserVars( $integrationParams->get( 'cbgj_auto_name' . $i, null, GetterInterface::STRING ) );

						if ( ! $name ) {
							continue 2;
						}

						$group							=	new GroupTable();

						if ( $integrationParams->get( 'cbgj_auto_unique' . $i, 1, GetterInterface::BOOLEAN ) ) {
							$group->load( array( 'category' => (int) $category->get( 'id' ), 'user_id' => (int) $user->get( 'id' ), 'name' => $name ) );
						} else {
							$group->load( array( 'category' => (int) $category->get( 'id' ), 'name' => $name ) );
						}

						if ( ! $group->get( 'id' ) ) {
							continue 2;
						}

						$group->delete();
						break;
					case 1:
						$groups							=	$integrationParams->get( 'cbgj_auto_usr_groups' . $i, null, GetterInterface::STRING );

						if ( ! $groups ) {
							continue 2;
						}

						$groups							=	explode( '|*|', $groups );

						cbArrayToInts( $groups );

						foreach ( $groups as $groupId ) {
							$group						=	new GroupTable();

							$group->load( (int) $groupId );

							if ( ! $group->get( 'id' ) ) {
								continue;
							}

							$groupUser					=	new \CB\Plugin\GroupJive\Table\UserTable( $_CB_database );

							$groupUser->load( array( 'group' => (int) $group->get( 'id' ), 'user_id' => (int) $user->get( 'id' ) ) );

							if ( ( ! $groupUser->get( 'id' ) ) || ( $groupUser->get( 'status' ) == 4 ) ) {
								continue;
							}

							$groupUser->delete();
						}
						break;
				}
			}
		}
	}

	/**
	 * Returns the version of GJ installed (2.x or 3.x)
	 * Function for the backend XML
	 *
	 * @return bool|string
	 */
	public function GJVersion()
	{
		global $_CB_framework;

		if ( file_exists( $_CB_framework->getCfg( 'absolute_path' ) . '/components/com_comprofiler/plugin/user/plug_cbgroupjive/cbgroupjive.class.php' ) ) {
			return '2.x';
		} elseif ( file_exists( $_CB_framework->getCfg( 'absolute_path' ) . '/components/com_comprofiler/plugin/user/plug_cbgroupjive/xml/metadata.xml' ) ) {
			return '3.x';
		}

		return false;
	}

	/**
	 * Returns options array for categories
	 * Function for the backend XML
	 *
	 * @return array
	 */
	public function loadGJCategoryList()
	{
 		global $_CB_framework;

		$api	=	$_CB_framework->getCfg( 'absolute_path' ) . '/components/com_comprofiler/plugin/user/plug_cbgroupjive/cbgroupjive.class.php';

		if ( file_exists( $api ) ) {
			/** @noinspection PhpIncludeInspection */
			require_once( $api );

			return cbgjClass::getCategoryOptions( null );
		} elseif ( file_exists( $_CB_framework->getCfg( 'absolute_path' ) . '/components/com_comprofiler/plugin/user/plug_cbgroupjive/xml/metadata.xml' ) ) {
			return CBGroupJive::getCategoryOptions();
		}

		return array();
	}

	/**
	 * Returns options array for category parents
	 * Function for the backend XML
	 *
	 * @return array
	 */
	public function loadGJParentCategoryList()
	{
 		global $_CB_framework;

		$api	=	$_CB_framework->getCfg( 'absolute_path' ) . '/components/com_comprofiler/plugin/user/plug_cbgroupjive/cbgroupjive.class.php';

		if ( ! file_exists( $api ) ) {
			return array();
		}

		/** @noinspection PhpIncludeInspection */
		require_once( $api );

		return cbgjClass::getCategoryOptions( null );
	}

	/**
	 * Returns options array for groups
	 * Function for the backend XML
	 *
	 * @return array
	 */
	public function loadGJGroupsList()
	{
 		global $_CB_framework;

		$api	=	$_CB_framework->getCfg( 'absolute_path' ) . '/components/com_comprofiler/plugin/user/plug_cbgroupjive/cbgroupjive.class.php';

		if ( file_exists( $api ) ) {
			/** @noinspection PhpIncludeInspection */
			require_once( $api );

			return cbgjClass::getGroupOptions( null );
		} elseif ( file_exists( $_CB_framework->getCfg( 'absolute_path' ) . '/components/com_comprofiler/plugin/user/plug_cbgroupjive/xml/metadata.xml' ) ) {
			return CBGroupJive::getGroupOptions();
		}

		return array();
	}

	/**
	 * Returns options array for group parents
	 * Function for the backend XML
	 *
	 * @return array
	 */
	public function loadGJParentGroupsList()
	{
 		global $_CB_framework;

		$api	=	$_CB_framework->getCfg( 'absolute_path' ) . '/components/com_comprofiler/plugin/user/plug_cbgroupjive/cbgroupjive.class.php';

		if ( ! file_exists( $api ) ) {
			return array();
		}

		/** @noinspection PhpIncludeInspection */
		require_once( $api );

		return cbgjClass::getGroupOptions( null );
	}
}
