<?php
/**
* @version $Id: $
* @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
* @subpackage Template for Paid Subscriptions
* @copyright (C) 2007-2022 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Application\Application;
use CB\Plugin\FamilyPlans\TemplateHandler;
use CB\Plugin\FamilyPlans\Table\FamilyTable;
use CBLib\Registry\GetterInterface;
use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class cbpaidSharedListView extends TemplateHandler
{
	/** @var FamilyTable[] */
	public $_model				=	array();
	/** @var UserTable */
	public $user				=	null;
	/** @var cbpaidSomething */
	public $subscription		=	null;
	/** @var null|\cbPageNav */
	public $paging				=	null;
	/** @var bool */
	public $search				=	null;
	/** @var bool */
	public $searching			=	false;
	/** @var array */
	public $recipients			=	array();
	/** @var string */
	public $shareListURL		=	null;
	/** @var string */
	public $confirmDelete		=	null;
	/** @var string */
	public $confirmCancel		=	null;
	/** @var string */
	public $cancelURL			=	null;
	/** @var string */
	public $fromUser			=	null;
	/** @var string */
	public $shareTitle			=	null;

	/**
	 * Returns the version of the implemented View
	 *
	 * @return int
	 */
	public function version()
	{
		return 1;
	}

	/**
	 * Draws the share button linking to shared list
	 *
	 * @param UserTable       $user
	 * @param cbpaidSomething $subscription
	 * @return string
	 */
	public function drawShareButton( $user, $subscription )
	{
		global $_CB_framework;

		if ( Application::MyUser()->getUserId() != $user->get( 'id', 0, GetterInterface::INT ) ) {
			$shareListURL	=	$_CB_framework->pluginClassUrl( array( 'plugin' => 'cbpaidsubscriptions', 'do' => 'sharedsubscription', 'user' => $user->get( 'id', 0, GetterInterface::INT ), 'subscription' => $subscription->get( 'id', 0, GetterInterface::INT ) ), false );
		} else {
			$shareListURL	=	$_CB_framework->pluginClassUrl( array( 'plugin' => 'cbpaidsubscriptions', 'do' => 'sharedsubscription', 'subscription' => $subscription->get( 'id', 0, GetterInterface::INT ) ), false );
		}

		$this->user			=	$user;
		$this->subscription	=	$subscription;
		$this->shareListURL	=	$shareListURL;

		return $this->display( 'sharebutton' );
	}

	/**
	 * Draws the cancel button for shared subscription users to leave the family
	 *
	 * @param UserTable       $user
	 * @param cbpaidSomething $subscription
	 * @return string
	 */
	public function drawCancelButton( $user, $subscription )
	{
		global $_CB_framework;

		initToolTip();

		if ( Application::MyUser()->getUserId() != $user->get( 'id', 0, GetterInterface::INT ) ) {
			$cancelURL				=	$_CB_framework->pluginClassUrl( array( 'plugin' => 'cbpaidsubscriptions', 'do' => 'sharedcancel', 'user' => $user->get( 'id', 0, GetterInterface::INT ), 'subscription' => $subscription->get( '_id', 0, GetterInterface::INT ) ), false );
		} else {
			$cancelURL				=	$_CB_framework->pluginClassUrl( array( 'plugin' => 'cbpaidsubscriptions', 'do' => 'sharedcancel', 'subscription' => $subscription->get( '_id', 0, GetterInterface::INT ) ), false );
		}

		$this->user					=	$user;
		$this->subscription			=	$subscription;
		$this->cancelURL			=	$cancelURL;
		$this->fromUser				=	CBuser::getInstance( $this->subscription->get( '_user_id', 0, GetterInterface::INT ), false )->getField( 'formatname', null, 'html', 'none', 'list', 0, true );
		$this->confirmCancel		=	"cbjQuery.cbconfirm( '" . addslashes( CBTxt::T( 'Are you sure you want to cancel this shared subscription?' ) ) . "' ).done( function() { window.location.href = '" . addslashes( $this->cancelURL ) . "'; })";

		return $this->display( 'cancelbutton' );
	}

	/**
	 * Sets the base shared list variables
	 *
	 * @param UserTable  $user
	 * @param \cbPageNav $paging
	 * @param bool       $searching
	 */
	private function setSharedList( $user, $paging, $searching )
	{
		global $_CB_framework;

		initToolTip();
		outputCbJs();
		cbValidator::loadValidation();

		$js								=	"$( '.cbsubsSharedShareFormEmail' ).on( 'keyup', function() {"
										.		"if ( $( this ).val() == '' ) {"
										.			"$( '.cbsubsSharedShareFormBtn' ).prop( 'disabled', true );"
										.		"} else {"
										.			"$( '.cbsubsSharedShareFormBtn' ).prop( 'disabled', false );"
										.		"}"
										.	"});"
										.	"$( '.cbsubsSharedSelectAll,.cbsubsSharedSelectCheckbox' ).on( 'change', function() {"
										.		"if ( $( '.cbsubsSharedList' ).find( '.cbsubsSharedSelectCheckbox:checked' ).length > 0 ) {"
										.			"$( '.cbsubsSharedDelete,.cbsubsSharedCancel,.cbsubsSharedResend' ).prop( 'disabled', false );"
										.		"} else {"
										.			"$( '.cbsubsSharedDelete,.cbsubsSharedCancel,.cbsubsSharedResend' ).prop( 'disabled', true );"
										.		"}"
										.	"});";

		$_CB_framework->outputCbJQuery( $js );

		$this->user						=	$user;
		$this->shareListURL				=	$paging->getBaseURL();
		$this->paging					=	$paging;
		$this->search					=	'<input type="text" name="shared_search" value="' . htmlspecialchars( $_CB_framework->getUserStateFromRequest( 'shared_search{com_comprofiler}', 'shared_search', '' ) ) . '" onchange="this.form.submit();" placeholder="' . htmlspecialchars( CBTxt::T( 'Search Shared...' ) ) . '" class="form-control" aria-label="' . htmlspecialchars( CBTxt::T( 'Search Shared' ) ) . '" />';
		$this->searching				=	$searching;
		$this->confirmDelete			=	"cbjQuery.cbconfirm( '" . addslashes( CBTxt::T( 'Are you sure you want to delete the selected shared subscriptions?' ) ) . "' ).done( function() { document.cbsubsSharedForm.act.value = 'delete'; document.cbsubsSharedForm.submit(); }); return false;";
		$this->confirmCancel			=	"cbjQuery.cbconfirm( '" . addslashes( CBTxt::T( 'Are you sure you want to cancel the selected shared subscriptions?' ) ) . "' ).done( function() { document.cbsubsSharedForm.act.value = 'cancel'; document.cbsubsSharedForm.submit(); }); return false;";
	}

	/**
	 * Sets the shared recipient whether from the user or to the user
	 *
	 * @param bool $fromUser
	 */
	private function setSharedRecipients( $fromUser = true )
	{
		foreach ( $this->_model as $i ) {
			if ( ! $fromUser ) {
				$recipient				=	CBuser::getInstance( $i->get( 'user_id', 0, GetterInterface::INT ), false )->getField( 'formatname', null, 'html', 'none', 'list', 0, true );
			} else {
				if ( $i->get( 'user', 0, GetterInterface::INT ) ) {
					$recipient			=	CBuser::getInstance( $i->get( 'user', 0, GetterInterface::INT ), false )->getField( 'formatname', null, 'html', 'none', 'list', 0, true );
				} else {
					$recipient			=	htmlspecialchars( $i->get( 'to', null, GetterInterface::STRING ) );
				}
			}

			$this->recipients[$i->id]	=	$recipient;
		}
	}

	/**
	 * Draws the shared subscriptions list from the user
	 *
	 * @param UserTable  $user
	 * @param \cbPageNav $paging
	 * @param bool       $searching
	 * @return string
	 */
	public function drawSharedFromList( $user, $paging, $searching )
	{
		$this->setSharedList( $user, $paging, $searching );
		$this->setSharedRecipients();

		return $this->display( 'from' );
	}

	/**
	 * Draws the link to the shared from list
	 *
	 * @param UserTable   $user
	 * @param null|string $title
	 * @return string
	 */
	public function drawSharedFromLink( $user, $title = null )
	{
		global $_CB_framework;

		if ( Application::MyUser()->getUserId() != $user->get( 'id', 0, GetterInterface::INT ) ) {
			$listUrl			=	$_CB_framework->pluginClassUrl( array( 'plugin' => 'cbpaidsubscriptions', 'do' => 'sharedsubscriptions', 'type' => 'from', 'user' => $user->get( 'id', 0, GetterInterface::INT ) ), false );
		} else {
			$listUrl			=	$_CB_framework->pluginClassUrl( array( 'plugin' => 'cbpaidsubscriptions', 'do' => 'sharedsubscriptions', 'type' => 'from' ), false );
		}

		$this->user				=	$user;
		$this->shareListURL		=	$listUrl;
		$this->shareTitle		=	$title;

		return $this->display( 'fromlink' );
	}

	/**
	 * Draws the shared subscriptions list to the user
	 *
	 * @param UserTable  $user
	 * @param \cbPageNav $paging
	 * @param bool       $searching
	 * @return string
	 */
	public function drawSharedToList( $user, $paging, $searching )
	{
		$this->setSharedList( $user, $paging, $searching );
		$this->setSharedRecipients( false );

		return $this->display( 'to' );
	}

	/**
	 * Draws the link to the shared to list
	 *
	 * @param UserTable   $user
	 * @param null|string $title
	 * @return string
	 */
	public function drawSharedToLink( $user, $title = null )
	{
		global $_CB_framework;

		if ( Application::MyUser()->getUserId() != $user->get( 'id', 0, GetterInterface::INT ) ) {
			$listUrl			=	$_CB_framework->pluginClassUrl( array( 'plugin' => 'cbpaidsubscriptions', 'do' => 'sharedsubscriptions', 'user' => $user->get( 'id', 0, GetterInterface::INT ) ), false );
		} else {
			$listUrl			=	$_CB_framework->pluginClassUrl( array( 'plugin' => 'cbpaidsubscriptions', 'do' => 'sharedsubscriptions' ), false );
		}

		$this->user				=	$user;
		$this->shareListURL		=	$listUrl;
		$this->shareTitle		=	$title;

		return $this->display( 'tolink' );
	}

	/**
	 * Draws the shared subscriptions list
	 *
	 * @param UserTable       $user
	 * @param cbpaidSomething $subscription
	 * @param \cbPageNav      $paging
	 * @param bool            $searching
	 * @return string
	 */
	public function drawSharedList( $user, $subscription, $paging, $searching )
	{
		$this->setSharedList( $user, $paging, $searching );
		$this->setSharedRecipients();

		$this->subscription		=	$subscription;

		return $this->display( 'default' );
	}
}
