<?php
/**
* @version $Id: $
* @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
* @subpackage Template for Paid Subscriptions
* @copyright (C) 2007-2022 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Application\Application;
use CB\Plugin\FamilyPlans\Table\FamilyTable;
use CBLib\Registry\GetterInterface;
use CB\Plugin\FamilyPlans\Helper;
use CBLib\Language\CBTxt;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_CB_framework;

$tmplVersion	=	1;	// This is the template version that needs to match
/** @var cbpaidSharedListView $this */
?>
<div class="cbsubsShared">
	<div class="mb-3 border-bottom cb-page-header cbsubsSharedHeader">
		<h3 class="m-0 p-0 mb-2 cb-page-header-title"><?php echo CBTxt::Th( 'SHARED_SUBSCRIPTIONS_FOR_PLAN', 'Shared Subscriptions for [plan_name]', array( '[plan_name]' => $this->subscription->getPersonalized( 'name', false ) ) ); ?></h3>
	</div>
	<div class="mb-2 row no-gutters cbsubsSharedHeader">
		<div class="col-sm text-center text-sm-left cbsubsSharedShare">
			<?php if ( ( $this->subscription->get( 'status', null, GetterInterface::STRING ) == 'A' ) && ( ! Helper::getCreateLimited( $this->subscription ) ) ) { ?>
			<form action="<?php echo htmlspecialchars( $this->shareListURL ); ?>" method="post" name="cbsubsSharedShareForm" class="m-0 cbValidation cbsubsSharedShareForm">
				<div class="input-group">
					<input type="text" id="to" name="to" class="form-control email cbsubsSharedShareFormEmail" placeholder="<?php echo htmlspecialchars( CBTxt::T( 'Email Address' ) ); ?>" aria-label="<?php echo htmlspecialchars( CBTxt::T( 'Email Address' ) ); ?>" />
					<div class="input-group-append">
						<button type="submit" name="act" value="share" class="btn btn-success cbsubsSharedShareFormBtn" disabled><?php echo CBTxt::T( 'Share' ); ?></button>
					</div>
				</div>
				<?php echo cbGetSpoofInputTag( 'plugin' ); ?>
			</form>
			<?php } ?>
		</div>
		<div class="offset-sm-2 col-sm-4 mt-1 mt-sm-0 text-sm-right cbsubsSharedSearch" role="search">
			<form action="<?php echo htmlspecialchars( $this->shareListURL ); ?>" method="post" name="cbsubsSharedSearchForm" class="m-0 cbsubsSharedSearchForm">
				<?php echo $this->paging->getLimitBox( false ); ?>
				<div class="input-group">
					<div class="input-group-prepend">
						<span class="input-group-text"><span class="fa fa-search"></span></span>
					</div>
					<?php echo $this->search; ?>
				</div>
			</form>
		</div>
	</div>
	<div class="table-responsive cbsubsSharedList">
		<?php if ( $this->_model ) { ?>
		<form action="<?php echo htmlspecialchars( $this->shareListURL ); ?>" method="post" name="cbsubsSharedForm" class="m-0 cbsubsSharedForm">
			<table class="m-0 table table-bordered cbsubsSharedListTable">
				<thead>
					<tr>
						<th style="width: 1%" scope="col" class="text-center cbsubsSharedSelect">
							<input type="checkbox" class="cbsubsSharedSelectAll" onclick="cbToggleAll( this, <?php echo count( $this->_model ); ?>, 'shared' );" aria-label="<?php echo htmlspecialchars( CBTxt::T( 'Select All' ) ); ?>" />
						</th>
						<th scope="col" class="text-wrap cbsubsSharedTo">
							<?php echo CBTxt::Th( 'To' ); ?>
						</th>
						<th style="width: 20%" scope="col" class="text-wrap text-center cbsubsSharedSent">
							<?php echo CBTxt::Th( 'Sent' ); ?>
						</th>
						<th style="width: 20%" scope="col" class="text-wrap text-center cbsubsSharedAccepted">
							<?php echo CBTxt::Th( 'Accepted' ); ?>
						</th>
					</tr>
				</thead>
				<tbody>
					<?php foreach ( $this->_model as /** @var FamilyTable $row */ $i => $row ) { ?>
					<tr>
						<td style="width: 1%" class="text-center cbsubsSharedSelect">
							<input type="checkbox" id="shared<?php echo htmlspecialchars( $i ); ?>" name="ids[]" value="<?php echo htmlspecialchars( $row->id ); ?>" class="cbsubsSharedSelectCheckbox" aria-label="<?php echo htmlspecialchars( CBTxt::T( 'Select Row' ) ); ?>" />
						</td>
						<td class="text-wrap cbsubsSharedTo">
							<?php echo $this->recipients[$row->id]; ?>
						</td>
						<td style="width: 20%" class="text-wrap text-center cbsubsSharedSent">
							<?php echo cbFormatDate( $row->get( 'sent', null, GetterInterface::STRING ), true, false ); ?>
						</td>
						<td style="width: 20%" class="text-wrap text-center cbsubsSharedAccepted">
							<?php echo cbFormatDate( $row->get( 'accepted', null, GetterInterface::STRING ), true, false ); ?>
						</td>
					</tr>
					<?php } ?>
				</tbody>
				<tfoot>
					<tr>
						<td colspan="4" class="cbsubsSharedActions">
							<button type="submit" onclick="<?php echo htmlspecialchars( $this->confirmDelete ); ?>" class="btn btn-sm btn-danger cbsubsSharedDelete" disabled><?php echo CBTxt::T( 'Delete' ); ?></button>
							<?php if ( $this->subscription->get( 'status', null, GetterInterface::STRING ) == 'A' ) { ?>
							<button type="submit" onclick="this.form.act.value = 'resend';" class="btn btn-sm btn-light border cbsubsSharedResend" disabled><?php echo CBTxt::T( 'Resend' ); ?></button>
							<?php } ?>
						</td>
					</tr>
				</tfoot>
			</table>
			<input type="hidden" name="act" value="" />
			<?php echo cbGetSpoofInputTag( 'plugin' ); ?>
		</form>
		<?php } else { ?>
			<?php echo CBTxt::Th( 'This subscription is not shared with anyone.' ); ?>
		<?php } ?>
	</div>
	<?php if ( $this->paging->total > $this->paging->limit ) { ?>
	<div class="mt-2 cbsubsSharedPaging">
		<?php echo $this->paging->getPagesLinks(); ?>
	</div>
	<?php } ?>
	<?php if ( ! Application::Cms()->getClientId() ) { ?>
	<div class="mt-2 cbControlButtonsLine cbsubsSharedBack">
		<a href="<?php echo $_CB_framework->userProfileUrl( $this->subscription->get( 'user_id', 0, GetterInterface::INT ), true, 'getcbpaidsubscriptionsTab' ); ?>">
			<?php echo CBTxt::Th( 'Click here to go back to your user profile' ); ?>
		</a>
	</div>
	<?php } ?>
</div>