<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Core\AutoLoader;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_PLUGINS;

AutoLoader::registerExactMap( '%^CB/Plugin/FamilyPlans/(.+)%i', __DIR__ . '/library/$1.php' );

$_PLUGINS->registerFunction( 'onAfterDeleteUser', 'deleteSharedSubscriptions', '\CB\Plugin\FamilyPlans\Trigger\UserTrigger' );

$_PLUGINS->registerFunction( 'onCPayIntegrationAction', 'showSharedSubscriptions', '\CB\Plugin\FamilyPlans\Trigger\SubscriptionsTrigger' );
$_PLUGINS->registerFunction( 'onCPayUserSubscriptions', 'getSharedSubscriptions', '\CB\Plugin\FamilyPlans\Trigger\SubscriptionsTrigger' );
$_PLUGINS->registerFunction( 'onCPayUserStateChange', 'sharedSubscriptionStateChanged', '\CB\Plugin\FamilyPlans\Trigger\SubscriptionsTrigger' );
$_PLUGINS->registerFunction( 'onCPayBeforeDrawSomething', 'displaySubscription', '\CB\Plugin\FamilyPlans\Trigger\SubscriptionsTrigger' );
$_PLUGINS->registerFunction( 'onCPayLoadPublishedPlans', 'loadPlans', '\CB\Plugin\FamilyPlans\Trigger\SubscriptionsTrigger' );
$_PLUGINS->registerFunction( 'onCPayBeforeDrawPlan', 'displayPlan', '\CB\Plugin\FamilyPlans\Trigger\SubscriptionsTrigger' );
$_PLUGINS->registerFunction( 'onCPayAfterDisplayProductPeriodPrice', 'displayPrice', '\CB\Plugin\FamilyPlans\Trigger\SubscriptionsTrigger' );
$_PLUGINS->registerFunction( 'onCPayBeforeUserRegistration', 'sharedSubscriptionValidation', '\CB\Plugin\FamilyPlans\Trigger\SubscriptionsTrigger' );
$_PLUGINS->registerFunction( 'onCPayAfterUserRegistration', 'sharedSubscriptionRegistration', '\CB\Plugin\FamilyPlans\Trigger\SubscriptionsTrigger' );
$_PLUGINS->registerFunction( 'onCPayDisplaySubscriptionsTab', 'displaySubscriptions', '\CB\Plugin\FamilyPlans\Trigger\SubscriptionsTrigger' );
