<?php
/**
 * CBSubs (TM): Community Builder Paid Subscriptions Plugin: cbsubsemail
 * @version $Id: cbsubs.alphauserpoints.php 1465 2012-07-10 17:37:13Z beat $
 * @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
 * @subpackage cbsubs.email.php
 * @author Beat
 * @copyright (C) 2007-2022 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

use CB\Database\Table\UserTable;
use CBLib\Registry\ParamsInterface;
use AcyMailing\Classes\UserClass;
use AcyMailing\Classes\ListClass;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_PLUGINS;

$_PLUGINS->registerFunction( 'onCPayUserStateChange', 'onCPayUserStateChange', 'getcbsubsacymailingTab' );

/**
 * CBSubs ACYmailing integration plugin class
 */
class getcbsubsacymailingTab extends cbTabHandler
{

	/**
	 * Called at each change of user subscription state due to a plan activation or deactivation
	 *
	 * @param  UserTable  $user
	 * @param  string              $status
	 * @param  int                 $planId
	 * @param  int                 $replacedPlanId
	 * @param  ParamsInterface     $integrationParams
	 * @param  string              $cause            'PaidSubscription' (first activation only), 'SubscriptionActivated' (renewals, cancellation reversals), 'SubscriptionDeactivated', 'Denied'
	 * @param  string              $reason           'N' new subscription, 'R' renewal, 'U'=update )
	 * @param  int                 $now              Unix time
	 */
	public function onCPayUserStateChange( &$user, $status, /** @noinspection PhpUnusedParameterInspection */ $planId, /** @noinspection PhpUnusedParameterInspection */ $replacedPlanId, &$integrationParams, $cause, /** @noinspection PhpUnusedParameterInspection */ $reason, /** @noinspection PhpUnusedParameterInspection */ $now )
	{
		global $_CB_framework;

		if ( ( $user === null ) || ( ! $this->acyMailingInstalled() ) ) {
			return;
		}

		$listsActive					=	$integrationParams->getString( 'cbacy_lists_activation' );

		if ( $listsActive ) {
			$listsActive				=	cbToArrayOfInt( explode( '|*|', $listsActive ) );
		}

		$listsDeactive					=	$integrationParams->getString( 'cbacy_lists_deactivation' );

		if ( $listsDeactive ) {
			$listsDeactive				=	cbToArrayOfInt( explode( '|*|', $listsDeactive ) );
		}

		if ( ( ! $listsActive ) && ( ! $listsDeactive ) ) {
			return;
		}

		$subscriber						=	null;

		if ( $this->acyMailingVersion() === 6 ) {
			require_once( $_CB_framework->getCfg( 'absolute_path' ) . '/administrator/components/com_acym/helpers/helper.php' );

			if ( class_exists( '\AcyMailing\Classes\UserClass' ) ) {
				$acyUser				=	new UserClass();
			} else {
				/** @var acymuserClass $acyUser */
				$acyUser				=	acym_get( 'class.user' );
			}

			$subscriber					=	$acyUser->getOneByCMSId( $user->getInt( 'id', 0 ) );

			if ( ( ! $subscriber ) || ( ! (int) $subscriber->id ) ) {
				$subscriber				=	$acyUser->getOneByEmail( $user->getString( 'email' ) );
			}

			$subscriberId				=	( $subscriber ? (int) $subscriber->id : 0 );
		} else {
			require_once( $_CB_framework->getCfg( 'absolute_path' ) . '/administrator/components/com_acymailing/helpers/helper.php' );

			/** @var subscriberClass $acyUser */
			$acyUser					=	acymailing_get( 'class.subscriber' );
			$subscriberId				=	$acyUser->subid( $user->getInt( 'id', 0 ) );

			if ( ! $subscriberId ) {
				$subscriberId			=	$acyUser->subid( $user->getString( 'email' ) );
			}
		}

		if ( ! $subscriberId ) {
			$newSubscriber				=	new stdClass();
			$newSubscriber->email		=	$user->getString( 'email' );
			$newSubscriber->name		=	$user->getString( 'name' );

			if ( $this->acyMailingVersion() === 6 ) {
				$newSubscriber->cms_id	=	$user->getInt( 'id', 0 );
				$newSubscriber->source	=	'joomla';
				$newSubscriber->active	=	1;

				if ( class_exists( '\AcyMailing\Classes\UserClass' ) ) {
					$acyUser->sendConf	=	false;
				}
			} else {
				$newSubscriber->userid	=	$user->getInt( 'id', 0 );
				$newSubscriber->created	=	cbpaidTimes::getInstance()->strToTime( $user->getString( 'registerDate' ) );
				$newSubscriber->enabled	=	1;
				$newSubscriber->accept	=	1;
				$newSubscriber->ip		=	$user->getString( 'registeripaddr' );
				$newSubscriber->html	=	1;
			}

			$newSubscriber->confirmed	=	1;

			$subscriberId				=	$acyUser->save( $newSubscriber );
		} elseif ( $subscriber ) {
			if ( ! $subscriber->cms_id ) {
				$subscriber->cms_id		=	$user->getInt( 'id', 0 );
				$subscriber->source		=	'joomla';

				$acyUser->save( $subscriber );
			}
		}

		if ( ! $subscriberId ) {
			return;
		}

		$removeActive					=	$integrationParams->getBool( 'cbacy_remove_activation', true );
		$removeDeactive					=	$integrationParams->getBool( 'cbacy_remove_deactivation', false );

		if ( $this->acyMailingVersion() === 6 ) {
			if ( ( $status === 'A' ) && ( $cause === 'PaidSubscription' ) ) {
				if ( $listsDeactive && $removeDeactive ) {
					$acyUser->unsubscribe( $subscriberId, $listsDeactive );
				}

				if ( $listsActive ) {
					$acyUser->subscribe( $subscriberId, $listsActive );
				}
			} elseif ( in_array( $status, array( 'X', 'C' ), true ) && ( $cause !== 'Pending' ) ) {
				if ( $listsActive && $removeActive ) {
					$acyUser->unsubscribe( $subscriberId, $listsActive );
				}

				if ( $listsDeactive ) {
					$acyUser->subscribe( $subscriberId, $listsDeactive );
				}
			}
		} else {
			$lists						=	array();

			if ( ( $status === 'A' ) && ( $cause === 'PaidSubscription' ) ) {
				if ( $listsDeactive && $removeDeactive ) {
					$lists				=	$this->removeLists( $lists, $listsDeactive );
				}

				if ( $listsActive ) {
					$lists				=	$this->addLists( $lists, $listsActive );
				}
			} elseif ( in_array( $status, array( 'X', 'C' ), true ) && ( $cause !== 'Pending' ) ) {
				if ( $listsActive && $removeActive ) {
					$lists				=	$this->removeLists( $lists, $listsActive );
				}

				if ( $listsDeactive ) {
					$lists				=	$this->addLists( $lists, $listsDeactive );
				}
			}

			if ( ! empty( $lists ) ) {
				$acyUser->saveSubscription( $subscriberId, $lists );
			}
		}
	}

	/**
	 * add lists
	 *
	 * @param array $lists
	 * @param array $add
	 * @return array
	 */
	protected function addLists( $lists, $add )
	{
		foreach ( $add as $id ) {
			$subscribe				=	null;
			$subscribe['status']	=	1;

			$lists[$id]				=	$subscribe;
		}

		return $lists;
	}

	/**
	 * remove lists
	 *
	 * @param array $lists
	 * @param array $remove
	 * @return array
	 */
	protected function removeLists( $lists, $remove )
	{
		foreach ( $remove as $id ) {
			$subscribe				=	null;
			$subscribe['status']	=	0;

			$lists[$id]				=	$subscribe;
		}

		return $lists;
	}

	/**
	 * Function for the backend XML
	 *
	 * @return array
	 */
	public function loadLists()
	{
		global $_CB_framework;

		if ( ! $this->acyMailingInstalled() ) {
			return array();
		}

		$lists				=	array();

		if ( $this->acyMailingVersion() === 6 ) {
			require_once( $_CB_framework->getCfg( 'absolute_path' ) . '/administrator/components/com_acym/helpers/helper.php' );

			if ( class_exists( '\AcyMailing\Classes\ListClass' ) ) {
				$acyList	=	new ListClass();
			} else {
				/** @var acymlistClass $acyList */
				$acyList	=	acym_get( 'class.list' );
			}

			$rows			=	$acyList->getAll();

			if ( ! $rows ) {
				return array();
			}

			foreach ( $rows as $row ) {
				$lists[]	=	\moscomprofilerHTML::makeOption( (string) $row->id, $row->name );
			}
		} else {
			require_once( $_CB_framework->getCfg( 'absolute_path' ) . '/administrator/components/com_acymailing/helpers/helper.php' );

			/** @var listClass $acyList */
			$acyList		=	acymailing_get( 'class.list' );
			$rows			=	$acyList->getLists();

			if ( ! $rows ) {
				return array();
			}

			foreach ( $rows as $row ) {
				$lists[]	=	\moscomprofilerHTML::makeOption( (string) $row->listid, $row->name );
			}
		}

		return $lists;
	}

	/**
	 * @return bool
	 */
	public function acyMailingInstalled()
	{
		if ( $this->acyMailingVersion() ) {
			return true;
		}

		return false;
	}

	/**       
	 * @return int
	 */
	private function acyMailingVersion()
	{
		global $_CB_framework;

		if ( file_exists( $_CB_framework->getCfg( 'absolute_path' ) . '/administrator/components/com_acym/helpers/helper.php' ) ) {
			return 6;
		}

		if ( file_exists( $_CB_framework->getCfg( 'absolute_path' ) . '/administrator/components/com_acymailing/helpers/helper.php' ) ) {
			return 5;
		}

		return 0;
	}
}
