/**
 * Copyright (C) 2007-2022 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
 * License: GNU General Public License version 2 http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 */
// var cbpayHideFields;

(function($) {
	var cbpaySels;
	var cbpayFirstTimeDone = false;
	var cbpayPlansConds = [];
	/**
	 * Handles the checking/unchecking of plans and the corresponding hiding of children plans and of registration-fields:
	 */
	function paidsubsChange(e) {
		var fieldsToShow = [];
		var fieldsToHide = [];
		var r  = new RegExp("^cbpplan[EN]\\[(\\d+)\\]\\[selected\\]\\[\\]$", "");
		if ( ! cbpayFirstTimeDone ) {
			// first time:
			cbpaySels.each( function(i) {
				if ( $(this).prop("checked") || ( ( $(this).attr("type") === "hidden") && ($(this).val() > 0) ) ) {
					$(this).attr("cbsubschkdef", "1" );
				}
			});
			cbpaySels.each( function(i) {
				var iPlan = r.exec( $(this).attr("name") );
				if ( iPlan[1] === "0" ) {
					// checks if the selected plan has no parent, its childrens are set to default values:
					if ( $(this).prop("checked") || ( ( $(this).attr("type" ) === "hidden") && ($(this).val() > 0) ) ) {
						cbpaySels.filter( "[name=\"cbpplanE[" + $(this).val() + "][selected][]\"],[name=\"cbpplanN[" + $(this).val() + "][selected][]\"]" ).filter( function() {
							return ( $(this).attr("cbsubschkdef") === "1");
						} ).attr( "checked", true );
					}
				} else {
					// checks that parent plan is checked, if exists, otherwise unchecks this:
					if ( cbpaySels.filter( "[value=\"" + parseInt(iPlan[1]) + "\"]" ).filter( "[name=\"cbpplanE[0][selected][]\"],[name=\"cbpplanN[0][selected][]\"]" ).prop("checked") === "" ) {
						$(this).prop( "checked", false );
					}
				}
			});
		} else {
			var clickedObject = $( typeof(e) !== "undefined" ? ( typeof(e.target) !== "undefined" ? e.target : e ) : "" );
			var clickedPlan = r.exec(clickedObject.attr("name"));
			if ( clickedPlan !== null ) {
				if ( clickedPlan[1] === "0" ) {
					// a parent plan has been clicked:
					if ( clickedObject.prop("checked") ) {
						// if it's now checked, its childrens are set to default values:
						cbpaySels.filter( "[name=\"cbpplanE[" + clickedObject.val() + "][selected][]\"],[name=\"cbpplanN[" + clickedObject.val() + "][selected][]\"]" ).filter( function() {
							return ( $(this).attr("cbsubschkdef") === "1");
						} ).prop( "checked", true );
					}
				} else {
					// a child plan has been clicked:
					// then, if a child is checked, checks its parent too:
					var p = cbpaySels.filter( "[value=\"" + parseInt(clickedPlan[1]) + "\"]" ).filter( "[name=\"cbpplanE[0][selected][]\"],[name=\"cbpplanN[0][selected][]\"]" );
					if ( $(this).prop("checked") === true ) {
						p.prop( "checked", true );
						// and uncheck the children of other now unchecked (in case of radios) parents below
					}
				}
			}
		}
		cbpaySels.each( function(i) {
			var iPlan = r.exec( $(this).attr("name") );
			// and uncheck the children of unchecked parents:
			if ( ( iPlan[1] === "0" ) && ( $(this).val() !== "0" ) && ( ! $(this).prop("checked") ) ) {
				cbpaySels.filter( "[name=\"cbpplanE[" + $(this).val() + "][selected][]\"],[name=\"cbpplanN[" + $(this).val() + "][selected][]\"]" ).prop( "checked", false );
			}
		});
		cbpaySels.each( function(i) {
			// 1) decides which CB fields to show or hide:
			// 2) removes required from inputs as plan is not selected:
			if ( $(this).prop("checked") || ( ( $(this).attr("type" ) === "hidden") && ($(this).val() > 0) ) ) {
				fieldsToHide = fieldsToHide.concat( cbpayHideFields[$(this).val()] );
				$(this).closest(".cbregPlanSelector").find(".cbRegNameDesc").find(":not(.cbregSubPlanSelector) .fieldCell input.requiredDisabled,:not(.cbregSubPlanSelector) .fieldCell select.requiredDisabled").removeClass("requiredDisabled").addClass("required");
			} else {
				fieldsToShow = fieldsToShow.concat( cbpayHideFields[$(this).val()] );
				$(this).closest(".cbregPlanSelector").find(".cbRegNameDesc").find(":not(.cbregSubPlanSelector) .fieldCell input.required,:not(.cbregSubPlanSelector) .fieldCell select.required").removeClass("required").addClass("requiredDisabled");
			}
		});
		// Show or hide fields:
		var i,j,f,fieldToShow,fieldToHide;
		for (i=0;i<fieldsToShow.length;i++) {
			$("#cbfr_" + fieldsToShow[i] + ",#cbfrd_" + fieldsToShow[i] + ",#cbfr_" + fieldsToShow[i] + "__verify").removeClass("displayDisabled hidden").find(".fieldCell,.cb_field").removeClass("requiredDisabled").find(".requiredDisabled").removeClass("requiredDisabled cbValidationDisabled").addClass("required").attr("mosReq","1");
		}
		for (i=0;i<fieldsToHide.length;i++) {
			$("#cbfr_" + fieldsToHide[i] + ",#cbfrd_" + fieldsToHide[i] + ",#cbfr_" + fieldsToHide[i] + "__verify").addClass("displayDisabled hidden").find(".fieldCell,.cb_field").addClass("requiredDisabled").find("input.required,select.required,textarea.required").removeClass("required").addClass("requiredDisabled cbValidationDisabled").attr("mosReq","0");
		}
		// Show or hide plans at registration depending on conditions to show or hide:
		for (i=0; i<cbpayPlansConds.length;i++) {
			var cond = cbpayPlansConds[i];			// 	{ planId : planId, plansReq : plansReq, plansNotReq : plansNotReq, fieldsReq : fieldsReq, fieldsNotReq : fieldsNotReq, field1 : field1, regexp1 : regexp1 }

			// Checks plans conditions:
			var pOk = cond.plansReq.length ? false : true;
			// Any required plan is enough to show the target plan:
			for (j=0; j<cond.plansReq.length;j++) {
				if ( $("#cbregUpgrades #cbregProduct_"+cond.plansReq[j]+".cbregPlanSelector input.cbregTick").prop( "checked" ) === true ) {
					pOk = true;
					break;
				}
			}
			// All non-allowed plans must be unselected to show the target plan:
			for (j=0; j<cond.plansNotReq.length;j++) {
				if ( $("#cbregUpgrades #cbregProduct_"+cond.plansNotReq[j]+".cbregPlanSelector input.cbregTick").prop( "checked" ) === true ) {
					pOk = false;
					break;
				}
			}

			// check fields conditions:
			var fOk = true;
			// All required fields must be non-empty to show the target plan:
			for (j=0; j<cond.fieldsReq.length;j++) {
				f = $("#cbfv_"+cond.fieldsReq[j]+" input,#cbfv_"+cond.fieldsReq[j]+" select");
				if ( ! ( f.prop( "checked" ) === true || ( ( f.attr( "type" ) !== "checkbox" ) && ( f.attr( "type" ) !== "radio" ) && ( f.val() !== "" ) ) ) ) {
					fOk = false;
					break;
				}
			}
			// All non-allowed fields must be empty to show the target plan:
			for (j=0; j<cond.fieldsNotReq.length;j++) {
				f = $("#cbfv_"+cond.fieldsNotReq[j]+" input,#cbfv_"+cond.fieldsNotReq[j]+" select");
				if ( f.prop( "checked" ) === true || ( ( f.attr( "type" ) !== "checkbox" ) && ( f.attr( "type" ) !== "radio" ) && ( f.val() !== "" ) ) ) {
					fOk = false;
					break;
				}
			}
			if (cond.field1 > 0) {
				f = $("#cbfv_"+cond.field1+" input,#cbfv_"+cond.field1+" select");
				if ( f.length > 0 ) {
					var val = "";
					if ( ( f.attr( "type" ) === "checkbox" ) || ( f.attr( "type" ) === "radio" ) ) {
						f.each( function() {
							if ( $(this).prop( "checked" ) === true ) {
								val = val + ( val === "" ? "" : "|*|" ) + $(this).attr("value");
							}
						});
					} else if ( f.is("select") ) {
						val = f.val() || [];
						if ( $.isArray( val ) ) {
							val = val.join("|*|");
						}
					} else {
						val = f.val();
					}
					var op = cond.regexp1[0];
					if (op === "<" || op === "<") {
						var c = cond.regexp1.slice(1);
						if ( c.match(/^[0-9.]+$/) ) {
							if ( val.match(/^[0-9.]*$/) ) {
								// numbers compare:
								if ( op === "<" ) {
									if ( ! ( Number(val) < Number(c) ) ) {
										fOk = false;
									}
								} else {
									if ( ! ( Number(val) > Number(c) ) ) {
										fOk = false;
									}
								}
							} else {
								// field is not a number: fail
								fOk = false;
							}
						} else {
							// strings compare:
							if ( op === "<" ) {
								if ( ! ( val < c ) ) {
									fOk = false;
								}
							} else {
								if ( ! ( val > c ) ) {
									fOk = false;
								}
							}
						}
					} else if ( op === "/" ) {
						// regular expression compare:
						var rr = new RegExp(cond.regexp1.slice(1,-1));
						if ( ! val.match(rr) ) {
							fOk = false;
						}
					}
				}
			}

			// Now applies condition:
			var planTarget = $("#cbregUpgrades #cbregProduct_"+cond.planId+".cbregPlanSelector");
			if ( pOk && fOk ) {
				if ( cbpayFirstTimeDone ) {
					planTarget.slideDown("slow");
				} else {
					planTarget.show();
				}
				var targetWasVisible = planTarget.hasClass("cbregDoHideChildrenVisible");
				planTarget.removeClass("cbregDoHideChildrenHidden").addClass("cbregDoHideChildrenVisible");
				planTarget.find(".fieldCell input.requiredDisabled,.fieldCell select.requiredDisabled").removeClass("requiredDisabled").addClass("required").attr("mosReq","1");
				var tick = planTarget.find("input.cbregTick");
				if ( (!targetWasVisible) && ( tick.attr("cbsubschkdef") === "1" ) ) {
					tick.prop( "checked", true );
				}
			} else {
				if ( cbpayFirstTimeDone ) {
					planTarget.slideUp("slow");
				} else {
					planTarget.hide();
				}
				planTarget.removeClass("cbregDoHideChildrenVisible").addClass("cbregDoHideChildrenHidden");
				planTarget.find(".fieldCell input.required,.fieldCell select.required").removeClass("required").addClass("requiredDisabled").attr("mosReq","0");
				planTarget.find("input.cbregTick").prop( "checked", false );
			}
		}

		// Finally hides or shows children:
		$("#cbregUpgrades .cbregDoHideChildren input.cbregTick").each( function() {
			var subPlans = $(this).closest(".cbregPlanSelector").find(".cbRegNameDesc .cbregSubPlanSelector");
			if ( $(this).prop( "checked" ) === true ) {
				if ( cbpayFirstTimeDone ) {
					subPlans.slideDown("slow");
				} else {
					subPlans.show();
				}
				$(this).closest(".cbregPlanSelector").removeClass("cbregDoHideChildrenHidden").addClass("cbregDoHideChildrenVisible");
				subPlans.find(".fieldCell input.requiredDisabled,.fieldCell select.requiredDisabled").removeClass("requiredDisabled").addClass("required").attr("mosReq","1");
			} else {
				if ( cbpayFirstTimeDone ) {
					subPlans.slideUp("slow");
				} else {
					subPlans.hide();
				}
				$(this).closest(".cbregPlanSelector").removeClass("cbregDoHideChildrenVisible").addClass("cbregDoHideChildrenHidden");
				subPlans.find(".fieldCell input.required,.fieldCell select.required").removeClass("required").addClass("requiredDisabled").attr("mosReq","0");
			}
		});
		// adds class to selected ones:
		cbpaySels.each( function(i) {
			if ( $(this).prop("checked") ) {
				$(this).parents(".cbregPlanSelector").addClass("cbregPlanSelected");
			} else {
				$(this).parents(".cbregPlanSelector").removeClass("cbregPlanSelected");
			}
		});
		cbpayFirstTimeDone = true;
	}

	var donationSelval = [];

	/*
	 * Handles the Donation plans select drop-down:
	 */
	function paidsubsDonationSelect(event) {
		var selector = event.target;
		// [1]: prefix, [2]: parent_id, [3]: plan_id :
		var iNamePrefix = /^([^\[]+)[EN]\[([^\]]+)\]\[donate\]\[plan([^\]]+)\]\[donsel\]$/.exec($(selector).attr("name"));
		// unchecks the selection of the plan if the donation is not selected:
		$( "#"+iNamePrefix[1]+iNamePrefix[3] ).prop( "checked", ( $(selector).val() !== "" ) ).triggerHandler("click");
		// unhides the free donation field if the selected value is "other" (0):
		if ( $(selector).val() === "0" ) {
			$(selector).closest(".cbregDonationSelect").next("span.cbregDonationValue").fadeIn("slow");
			if ( ( typeof( donationSelval[$(selector).attr("name")] ) === "undefined" ) || ( ! donationSelval[$(selector).attr("name")] ) ) {
				$(selector).closest(".cbregDonationSelect").next("span.cbregDonationValue").children("input.cbregDonationFreeValue").focus();
				donationSelval[$(selector).attr("name")] = true;
			}
		} else {
			$(selector).closest(".cbregDonationSelect").next("span.cbregDonationValue").fadeOut("slow");
			donationSelval[$(selector).attr("name")] = false;
		}
		return true;
	}

	/*
	 * Handles any changes in the donation value to select or unselect plan
	 */
	function paidsubsDonationValueChange(donationValueField) {
		var checkboxOrRadio = $(donationValueField).parents(".cbRegNameDesc").slice(0,1).children("input.cbregTick:checkbox,input.cbregTick:radio");
		if (checkboxOrRadio) {
			var isZeroOrEmpty = ( /^\s*0*\.?0*\s*$/.test( $(donationValueField).val() ) );
			var wasChecked = checkboxOrRadio.prop("checked");
			if ( wasChecked === isZeroOrEmpty ) {
				checkboxOrRadio.prop("checked", ! isZeroOrEmpty );
			}
		}
	}

	/*
	 * Handles the Donation plans free donation value text input box:
	 */
	function paidsubsDonationValueBlur(event) {
		var donationValueField = event.target;
		// if the donation selector selects "other" (0):
		if ( $(donationValueField).parents(".cbregDonationValue").slice(0,1).prev("span.cbregDonationSelect").children("select.cbregDonationSelector").val() === "0" ) {
			// [1]: prefix, [2]: parent_id, [3]: plan_id :
			var iNamePrefix = /^([^\[]+)[EN]\[([^\]]+)\]\[donate\]\[plan([^\]]+)\]\[donval\]$/.exec($(donationValueField).attr("name"));
			// checks if the value is non-zero float or empty:
			var isZeroOrEmpty = ( /^\s*0*\.?0*\s*$/.test( $(donationValueField).val() ) );
			// ticks/unticks the corresponding donation plan selector depending of free donation value and triggers the other events:
			$( "#"+iNamePrefix[1]+iNamePrefix[3] ).prop( "checked", ! isZeroOrEmpty ).triggerHandler("click");
		}
		paidsubsDonationValueChange(donationValueField);
		return true;
	}

	/*
	 * Handles the Donation plans free donation value text input box:
	 */
	function paidsubsDonationValueChangeKeyUp(event) {
		var donationValueField = event.target;
		// avoids non-float value character inputs:
		$(donationValueField).val( /[0-9]*\.?[0-9]*/.exec( $(donationValueField).val() ) );
		paidsubsDonationValueChange(donationValueField);
		return true;
	}

	var termsAccepted = false;
	var paybuttonsSelector = ".cbpayChoices .cbpaidCCbutton form input[type=\"image\"], .cbpayChoices .cbpaidCCbutton form input[type=\"submit\"], .cbpayChoices .cbpaidCCbutton form input[type=\"button\"], .cbpayChoices .cbpaidCCbutton form input[type=\"radio\"], .cbpayChoices .cbpaidCCbutton form button";

	/*
	 * In basket, terms and conditions acceptance got changed
	 */
	function paidsubsTermsAcceptChange() {
		if ( $( this ).prop( 'checked' ) ) {
			termsAccepted = true;

			$( '#cbregTermsError' ).remove();
			$( '.cbregPaymentChoices,.cbpayChoices' ).removeClass( 'cbregTermsFade' );
		} else {
			termsAccepted = false;

			$( '.cbregPaymentChoices,.cbpayChoices' ).addClass( 'cbregTermsFade' );
		}
	}
	var clickableDesc = true;
	/**
	 * Handles clicks into descriptions to select plan:
	 */
	function paidsubsClickDescription(event) {
		if ( clickableDesc ) {
			if ( $(event.target).filter("input,select,label,button,option,a").length === 0 ) {
				clickableDesc = false;
				var checkboxOfDesc = $(this).find("input.cbregTick[type!=\"hidden\"]").first().filter( ":not(:checked)");
				checkboxOfDesc.prop("checked",true).triggerHandler( 'change' );
				clickableDesc = true;
				paidsubsChange(checkboxOfDesc);		//checkboxOfDesc.click(); can not be used here, since it toggles the checkbox after calling other event handlers, while a real mouse click toggles the checkbox first.
			}
		}
	}
	function hextobin( hex ) {
		var bytes = [];
		for ( var i=0; i < hex.length-1; i+=2 ) {
			bytes.push( parseInt( hex.substr( i, 2 ), 16 ) );
		}
		return String.fromCharCode.apply(String, bytes);
	}
	var paidsubsInitDone = false;
	$.extend({
		cbpaidsubs : {
			paidsubsInit : function() {
				if ( paidsubsInitDone ) {
					return;
				}

				paidsubsInitDone = true;

				// parent and child plans selection:
				cbpaySels =	$( '#cbregUpgrades input' ).filter( function() {
								return /^cbpplan[EN]\[(\d+)\]\[selected\]\[\]$/.test( $( this ).attr( 'name' ) );
							});

				paidsubsChange();

				cbpaySels.on( 'click', paidsubsChange );

				// make whole plan description backend clickable:
				$( document ).on( 'click', '.cbregPlanSelector', paidsubsClickDescription );

				// donations:
				$( '#cbregUpgrades select.cbregDonationSelector' ).on( 'change', paidsubsDonationSelect );
				$( '#cbregUpgrades input.cbregDonationFreeValue' ).on( 'blur', paidsubsDonationValueBlur ).on( 'change keyup', paidsubsDonationValueChangeKeyUp );

				var cbpayContainer = $( '#cbpayOrderContainer' );
				var cbpPMajaxSubmited = false;

				var ajaxFormOptions = {
					target: cbpayContainer,
					type: 'POST',
					beforeSubmit: function(formData, jqForm, options) {
						options.url = hextobin( $( jqForm ).find( 'input[name="ajaxurl"]' ).attr( 'value' ) );

						$( '#cbpayOrderContainer>div' ).addClass( 'position-relative' ).prepend( '<div class="position-absolute d-flex flex-column justify-content-center align-items-center w-100 h-100 bg-light cbregAjLoading"><div class="spinner-border spinner-border-sm"></div></div>' );
					},
					success: function( responseText, statusText ) {
						attachRadios();

						cbpPMajaxSubmited = false;
					}
				};

				function attachRadios() {
					var termsConditions = $( 'input#terms_accepted' );

					if ( termsConditions.length ) {
						if ( termsAccepted ) {
							termsConditions.prop( 'checked', true );
						}

						termsConditions.on( 'change', paidsubsTermsAcceptChange ).triggerHandler( 'change' );

						$( '.cbregPaymentChoices,.cbpayChoices' ).on( 'click', function(e) {
							if ( ! termsConditions.prop( 'checked' ) ) {
								e.preventDefault();

								if ( $( '#cbregTermsError' ).length === 0 ) {
									$( '.cbregTermsAccept' ).after( '<div class="m-0 alert alert-warning cbregTermsNotice" id="cbregTermsError">' + $( 'button#cbTermsAccept' ).attr( 'title' ) + '</div>' );
								}

								return false;
							}
						}).removeClass( 'hidden' );

						$( 'button#cbTermsAccept' ).parent().addClass( 'hidden' );
					}

					$( '.cbregCCradioSelector form, .cbregCurrencySelect form, .cbsubsAjaxForm' ).ajaxForm( ajaxFormOptions );
					$( 'button#cbregSelectCurrency' ).parent().addClass( 'hidden' );
				}

				attachRadios();

				cbpayContainer.on( 'change', '.cpayOrderCurrency', function() {
					// In basket, currency got changed:
					if ( ! cbpPMajaxSubmited ) {
						// Disable all payment buttons while basket is changing its currency:
						$( paybuttonsSelector ).prop( 'disabled', false );

						cbpPMajaxSubmited = true;

						$( this.form ).submit();
					}
					return true;
				}).on( 'click', '.cbregconfirmtitleonclick input.cbpaidCCimageInput, .cbregconfirmtitleonclick button.cbpaidCCimageInput', function() {
					// change of currency payment buttons:
					var title = $( this ).attr( 'title' );

					if ( title === "" ) {
						return true;
					} else {
						if ( confirm( $( this ).attr( 'title' ) ) ) {
							$( '#cbpayOrderContainer>div' ).addClass( 'position-relative' ).prepend( '<div class="position-absolute d-flex flex-column justify-content-center align-items-center w-100 h-100 bg-light cbregAjLoading"><div class="spinner-border spinner-border-sm"></div></div>' );

							return true;
						} else {
							return false;
						}
					}
				}).on( 'click', '.cbregCCradioLi:not(.cbregCCradioSelected) .cbregCCradioSelector', function() {
					// In basket, radios for payment method got clicked:
					if ( ! cbpPMajaxSubmited ) {
						cbpPMajaxSubmited = true;

						$( $( this ).find( 'input:radio.cbpaidCCpaymethod' ).prop( 'checked', true )[0].form ).submit();
					}

					return true;
				});
			},
			paidsubsPlanConditions : function( planId, plansReq, plansNotReq, fieldsReq, fieldsNotReq, field1, regexp1 ) {
				var j,f;
				$.merge( cbpayPlansConds, [{ planId : planId, plansReq : plansReq, plansNotReq : plansNotReq, fieldsReq : fieldsReq, fieldsNotReq : fieldsNotReq, field1 : field1, regexp1 : regexp1 }] );
				for (j=0; j<fieldsReq.length;j++) {
					f = $("#cbfv_"+fieldsReq[j]+" input,#cbfv_"+fieldsReq[j]+" select");
					if ( ( f.attr( "type" ) !== "checkbox" ) && ( f.attr( "type" ) !== "radio" ) ) {
						f.on( 'change', paidsubsChange );
					} else {
						f.on( 'click', paidsubsChange );
					}
				}
				for (j=0; j<fieldsNotReq.length;j++) {
					f = $("#cbfv_"+fieldsNotReq[j]+" input,#cbfv_"+fieldsNotReq[j]+" select");
					if ( ( f.attr( "type" ) !== "checkbox" ) && ( f.attr( "type" ) !== "radio" ) ) {
						f.on( 'change', paidsubsChange );
					} else {
						f.on( 'click', paidsubsChange );
					}
				}
				if (field1 > 0) {
					f = $("#cbfv_"+field1+" input,#cbfv_"+field1+" select");
					if ( ( f.attr( "type" ) !== "checkbox" ) && ( f.attr( "type" ) !== "radio" ) ) {
						f.on( 'change', paidsubsChange );
					} else {
						f.on( 'click', paidsubsChange );
					}
				}
			}
		}
	});
})(jQuery);
