<?php
/**
 * CBLib, Community Builder Library(TM)
 *
 * @version       $Id: 23.12.16 18:05 $
 * @package       ${NAMESPACE}
 * @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
 * @license       http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

use CBLib\Application\Application;
use CB\Database\Table\UserTable;

defined( 'CBLIB' ) or die();

class cbpaidControllerPaymentsHistory
{
	/**
	 * Draws payments list
	 *
	 * @uses \CBLib\Application\Application::Input()
	 *
	 * @return string|boolean
	 */
	public static function showPaymentsList()
	{
		global $_CB_framework, $_CB_database;

		$params					=	cbpaidApp::settingsParams();

		if ( ! $params->getBool( 'show_payments_history', false ) ) {
			return false;
		}

		$userId					=	Application::Input()->getInt( 'user', 0 );

		if ( ! $userId ) {
			$user				=	\CBuser::getMyUserDataInstance();
		} else {
			$user				=	\CBuser::getUserDataInstance( $userId );
		}

		if ( ! $user->getInt( 'id', 0 ) ) {
			return false;
		}

		if ( ( Application::MyUser()->getUserId() !== $user->getInt( 'id', 0 ) )
			 && ( ! cbpaidApp::authoriseAction( 'cbsubs.sales' ) )
			 && ( ! cbpaidApp::authoriseAction( 'cbsubs.financial' ) )
		) {
			return false;
		}

		$basketId			=	Application::Input()->getInt( 'basket' );
		$invoiceId			=	Application::Input()->getString( 'invoice' );
		$paymentId			=	Application::Input()->getInt( 'payment' );
		$showPeriod			=	self::getPeriodDatetime();

		/** @var $viewer cbpaidPaymentsListView */
		$viewer				=	cbpaidTemplateHandler::getViewer( null, 'paymentslist' );

		$prefix				=	'payments_';
		$limitstart			=	(int) $_CB_framework->getUserStateFromRequest( $prefix . 'limitstart{com_comprofiler}', $prefix . 'limitstart', 0 );

		$query				=	"SELECT COUNT(*)"
							.	"\n FROM " . $_CB_database->NameQuote( '#__cbsubs_payments' ) . " AS p"
							.	"\n INNER JOIN " . $_CB_database->NameQuote( '#__cbsubs_payment_baskets' ) . " AS b"
							.	" ON b." . $_CB_database->NameQuote( 'id' ) . " = p." . $_CB_database->NameQuote( 'payment_basket_id' )
							.	"\n WHERE p." . $_CB_database->NameQuote( 'by_user_id' ) . " = " . $user->getInt( 'id', 0 );
		if ( $paymentId ) {
			$query			.=	"\n AND p." . $_CB_database->NameQuote( 'id' ) . " = " . (int) $paymentId;
		} elseif ( $basketId ) {
			$query			.=	"\n AND p." . $_CB_database->NameQuote( 'payment_basket_id' ) . " = " . (int) $basketId;
		} elseif ( $invoiceId ) {
			$query			.=	"\n AND p." . $_CB_database->NameQuote( 'invoice' ) . " = " . $_CB_database->Quote( $invoiceId );
		} elseif ( $showPeriod ) {
			$query			.=	"\n AND p." . $_CB_database->NameQuote( 'time_created' ) . " > " . $_CB_database->Quote( $showPeriod );
		}
		$_CB_database->setQuery( $query );
		$total				=	(int) $_CB_database->loadResult();

		$pageNav			=	new cbPageNav( $total, $limitstart, 30 );

		$pageNav->setInputNamePrefix( $prefix );
		$pageNav->setStaticLimit( true );

		if ( Application::MyUser()->getUserId() !== $user->getInt( 'id', 0 ) ) {
			$pageNav->setBaseURL( $_CB_framework->pluginClassUrl( array( 'plugin' => 'cbpaidsubscriptions', 'do' => 'showpaymentslist', 'user' => $user->getInt( 'id', 0 ) ), false, array( 'basket' => $basketId, 'invoice' => $invoiceId, 'payment' => $paymentId ) ) );
		} else {
			$pageNav->setBaseURL( $_CB_framework->pluginClassUrl( array( 'plugin' => 'cbpaidsubscriptions', 'do' => 'showpaymentslist' ), false, array( 'basket' => $basketId, 'invoice' => $invoiceId, 'payment' => $paymentId ) ) );
		}

		$query				=	"SELECT p.*"
							.	"\n FROM " . $_CB_database->NameQuote( '#__cbsubs_payments' ) . " AS p"
							.	"\n INNER JOIN " . $_CB_database->NameQuote( '#__cbsubs_payment_baskets' ) . " AS b"
							.	" ON b." . $_CB_database->NameQuote( 'id' ) . " = p." . $_CB_database->NameQuote( 'payment_basket_id' )
							.	"\n WHERE p." . $_CB_database->NameQuote( 'by_user_id' ) . " = " . $user->getInt( 'id', 0 );
		if ( $paymentId ) {
			$query			.=	"\n AND p." . $_CB_database->NameQuote( 'id' ) . " = " . (int) $paymentId;
		} elseif ( $basketId ) {
			$query			.=	"\n AND p." . $_CB_database->NameQuote( 'payment_basket_id' ) . " = " . (int) $basketId;
		} elseif ( $invoiceId ) {
			$query			.=	"\n AND p." . $_CB_database->NameQuote( 'invoice' ) . " = " . $_CB_database->Quote( $invoiceId );
		} elseif ( $showPeriod ) {
			$query			.=	"\n AND p." . $_CB_database->NameQuote( 'time_created' ) . " > " . $_CB_database->Quote( $showPeriod );
		}
		$query				.=	"\n ORDER BY p." . $_CB_database->NameQuote( 'time_created' ) . " DESC";
		$_CB_database->setQuery( $query, $pageNav->limitstart, $pageNav->limit );
		$rows				=	$_CB_database->loadObjectList( 'id', 'cbpaidPayment' );

		$viewer->setModel( $rows );

		return $viewer->drawPaymentsHistoryList( $user, $pageNav );
	}

	/**
	 * @param UserTable $user
	 * @return int
	 */
	public static function getPayments( $user )
	{
		global $_CB_database;

		$params			=	cbpaidApp::settingsParams();

		if ( ! $params->getBool( 'show_payments_history', false ) ) {
			return 0;
		}

		$showPeriod		=	self::getPeriodDatetime();

		$query			=	"SELECT COUNT(*)"
						.	"\n FROM " . $_CB_database->NameQuote( '#__cbsubs_payments' ) . " AS p"
						.	"\n INNER JOIN " . $_CB_database->NameQuote( '#__cbsubs_payment_baskets' ) . " AS b"
						.	" ON b." . $_CB_database->NameQuote( 'id' ) . " = p." . $_CB_database->NameQuote( 'payment_basket_id' )
						.	"\n WHERE p." . $_CB_database->NameQuote( 'by_user_id' ) . " = " . $user->getInt( 'id', 0 );
		if ( $showPeriod ) {
			$query		.=	"\n AND p." . $_CB_database->NameQuote( 'time_created' ) . " > " . $_CB_database->Quote( $showPeriod );
		}
		$_CB_database->setQuery( $query );

		return (int) $_CB_database->loadResult();
	}

	/**
	 * @return string|null
	 */
	private static function getPeriodDatetime()
	{
		global $_CB_database;

		$showPeriod		=	cbpaidApp::settingsParams()->getString( 'payments_history_show_period', '0000-06-00 00:00:00' );

		if ( ( ! $showPeriod ) || ( $showPeriod === '0000-00-00 00:00:00' ) ) {
			return null;
		}

		$duration		=	cbpaidTimes::getInstance()->dateInterval( $showPeriod );
		$systemTimeZone	=	new DateTimeZone( cbpaidTimes::getInstance()->systemTimeZone() );
		$endDate		=	new DateTime( '@' . Application::Application()->getStartTime(), $systemTimeZone );

		$endDate->setTimezone( $systemTimeZone );

		$startDate		=	$endDate->sub( $duration );

		return $_CB_database->getUtcDateTime( $startDate->getTimestamp() );
	}
}
