<?php
/**
 * CBLib, Community Builder Library(TM)
 *
 * @version       $Id: 23.12.16 18:05 $
 * @package       ${NAMESPACE}
 * @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
 * @license       http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

use CBLib\Application\Application;
use CB\Database\Table\UserTable;

defined( 'CBLIB' ) or die();

class cbpaidControllerInvoices
{
	/**
	 * Generates the HTML to display the plans and upgrade possibilities for subscription tab/area
	 * (frontend and backend)
	 * @uses \CBLib\Application\Application::Input()
	 *
	 * @return string|boolean         either string HTML for tab content, or false if ErrorMSG generated
	 */
	public static function showInvoicesList()
	{
		global $_CB_framework, $_CB_database;

		$params					=	cbpaidApp::settingsParams();

		if ( ! $params->getBool( 'show_invoices', true ) ) {
			return false;
		}

		$userId					=	Application::Input()->getInt( 'user', 0 );

		if ( ! $userId ) {
			$user				=	\CBuser::getMyUserDataInstance();
		} else {
			$user				=	\CBuser::getUserDataInstance( $userId );
		}

		if ( ! $user->getInt( 'id', 0 ) ) {
			return false;
		}

		if ( ( Application::MyUser()->getUserId() !== $user->getInt( 'id', 0 ) )
			 && ( ! cbpaidApp::authoriseAction( 'cbsubs.sales' ) )
			 && ( ! cbpaidApp::authoriseAction( 'cbsubs.financial' ) )
		) {
			return false;
		}

		$basketId			=	Application::Input()->getInt( 'basket' );
		$invoiceId			=	Application::Input()->getString( 'invoice' );
		$showPeriod			=	self::getPeriodDatetime();

		/** @var $viewer cbpaidInvoicesListView */
		$viewer				=	cbpaidTemplateHandler::getViewer( null, 'invoiceslist' );

		$prefix				=	'invoices_';
		$limitstart			=	(int) $_CB_framework->getUserStateFromRequest( $prefix . 'limitstart{com_comprofiler}', $prefix . 'limitstart', 0 );

		$query				=	"SELECT COUNT(*)"
							.	"\n FROM " . $_CB_database->NameQuote( '#__cbsubs_payment_baskets' )
							.	"\n WHERE " . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 );
		if ( $basketId ) {
			$query			.=	"\n AND " . $_CB_database->NameQuote( 'id' ) . " = " . (int) $basketId;
		} elseif ( $invoiceId ) {
			$query			.=	"\n AND " . $_CB_database->NameQuote( 'invoice' ) . " = " . $_CB_database->Quote( $invoiceId );
		} elseif ( $showPeriod ) {
			$query			.=	"\n AND " . $_CB_database->NameQuote( 'time_initiated' ) . " > " . $_CB_database->Quote( $showPeriod );
		}
		$query				.=	"\n AND " . $_CB_database->NameQuote( 'payment_status' ) . " IN " . $_CB_database->safeArrayOfStrings( array( 'Completed', 'Reversed', 'Refunded', 'Partially-Refunded', 'Pending', 'In-Progress' ) );
		$_CB_database->setQuery( $query );
		$total				=	(int) $_CB_database->loadResult();

		$pageNav			=	new cbPageNav( $total, $limitstart, 30 );

		$pageNav->setInputNamePrefix( $prefix );
		$pageNav->setStaticLimit( true );

		if ( Application::MyUser()->getUserId() !== $user->getInt( 'id', 0 ) ) {
			$pageNav->setBaseURL( $_CB_framework->pluginClassUrl( array( 'plugin' => 'cbpaidsubscriptions', 'do' => 'showinvoiceslist', 'user' => $user->getInt( 'id', 0 ) ), false, array( 'basket' => $basketId, 'invoice' => $invoiceId ) ) );
		} else {
			$pageNav->setBaseURL( $_CB_framework->pluginClassUrl( array( 'plugin' => 'cbpaidsubscriptions', 'do' => 'showinvoiceslist' ), false, array( 'basket' => $basketId, 'invoice' => $invoiceId ) ) );
		}

		$query				=	"SELECT *"
							.	"\n FROM " . $_CB_database->NameQuote( '#__cbsubs_payment_baskets' )
							.	"\n WHERE " . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 );
		if ( $basketId ) {
			$query			.=	"\n AND " . $_CB_database->NameQuote( 'id' ) . " = " . (int) $basketId;
		} elseif ( $invoiceId ) {
			$query			.=	"\n AND " . $_CB_database->NameQuote( 'invoice' ) . " = " . $_CB_database->Quote( $invoiceId );
		} elseif ( $showPeriod ) {
			$query			.=	"\n AND " . $_CB_database->NameQuote( 'time_initiated' ) . " > " . $_CB_database->Quote( $showPeriod );
		}
		$query				.=	"\n AND " . $_CB_database->NameQuote( 'payment_status' ) . " IN " . $_CB_database->safeArrayOfStrings( array( 'Completed', 'Reversed', 'Refunded', 'Partially-Refunded', 'Pending', 'In-Progress' ) )
							.	"\n ORDER BY " . $_CB_database->NameQuote( 'time_initiated' ) . " DESC";
		$_CB_database->setQuery( $query, $pageNav->limitstart, $pageNav->limit );
		$rows				=	$_CB_database->loadObjectList( 'id', 'cbpaidPaymentBasket' );

		$viewer->setModel( $rows );

		return $viewer->drawInvoicesList( $user, $pageNav );
	}

	/**
	 * @param UserTable $user
	 * @return int
	 */
	public static function getInvoices( $user )
	{
		global $_CB_database;

		$params			=	cbpaidApp::settingsParams();

		if ( ! $params->getBool( 'show_invoices', true ) ) {
			return 0;
		}

		$showPeriod		=	self::getPeriodDatetime();

		$query			=	"SELECT COUNT(*)"
						.	"\n FROM " . $_CB_database->NameQuote( '#__cbsubs_payment_baskets' )
						.	"\n WHERE " . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 );
		if ( $showPeriod ) {
			$query		.=	"\n AND " . $_CB_database->NameQuote( 'time_initiated' ) . " > " . $_CB_database->Quote( $showPeriod );
		}
		$query			.=	"\n AND " . $_CB_database->NameQuote( 'payment_status' ) . " IN " . $_CB_database->safeArrayOfStrings( array( 'Completed', 'Reversed', 'Refunded', 'Partially-Refunded', 'Pending', 'In-Progress' ) );
		$_CB_database->setQuery( $query );

		return (int) $_CB_database->loadResult();
	}

	/**
	 * @return string|null
	 */
	private static function getPeriodDatetime()
	{
		global $_CB_database;

		$showPeriod		=	cbpaidApp::settingsParams()->getString( 'invoices_show_period', '0000-06-00 00:00:00' );

		if ( ( ! $showPeriod ) || ( $showPeriod === '0000-00-00 00:00:00' ) ) {
			return null;
		}

		$duration		=	cbpaidTimes::getInstance()->dateInterval( $showPeriod );
		$systemTimeZone	=	new DateTimeZone( cbpaidTimes::getInstance()->systemTimeZone() );
		$endDate		=	new DateTime( '@' . Application::Application()->getStartTime(), $systemTimeZone );

		$endDate->setTimezone( $systemTimeZone );

		$startDate		=	$endDate->sub( $duration );

		return $_CB_database->getUtcDateTime( $startDate->getTimestamp() );
	}
}
