<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2023 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CBLib\Application\Application;
use CBLib\Language\CBTxt;

// ensure this file is being included by a parent file
if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class CBView_users {

	/**
	 * Outputs legacy plugin rows for legacy user management views
	 *
	 * @param  array $pluginRows
	 * @return null|string
	 * @deprecated 2.0
	 */
	public function _pluginRows( $pluginRows ) {
		$return				=	null;

		foreach ( $pluginRows as $pluginOutput ) {
			if ( is_array( $pluginOutput ) ) foreach ( $pluginOutput as $title => $content ) {
				$return		.=	'<div class="form-group row no-gutters cb_form_line">'
							.		'<label class="col-form-label col-sm-3 pr-sm-2">' . $title . '</label>'
							.		'<div class="cb_field col-sm-9">'
							.			'<div>' . $content . '</div>'
							.		'</div>'
							.	'</div>';
			}
		}

		return $return;
	}

	/**
	 * Outputs legacy mass mailer display
	 *
	 * @deprecated 2.0
	 *
	 * @param UserTable[]  $rows
	 * @param string       $emailTo
	 * @param string       $emailSubject
	 * @param string       $emailBody
	 * @param string       $emailAttach
	 * @param string       $emailCC
	 * @param string       $emailBCC
	 * @param string       $emailFromName
	 * @param string       $emailFromAddr
	 * @param string       $emailReplyName
	 * @param string       $emailReplyAddr
	 * @param int          $emailsPerBatch
	 * @param int          $emailsBatch
	 * @param int          $emailPause
	 * @param bool         $simulationMode
	 * @param array        $pluginRows
	 */
	public function emailUsers( $rows, $emailTo, $emailSubject, $emailBody, $emailAttach, $emailCC, $emailBCC, $emailFromName, $emailFromAddr, $emailReplyName, $emailReplyAddr, $emailsPerBatch, $emailsBatch, $emailPause, $simulationMode, $pluginRows ) {
		global $_CB_framework, $_CB_Backend_Title;

		_CBsecureAboveForm( 'showUsers' );

		cbimport( 'cb.validator' );
		outputCbTemplate( 2 );
		outputCbJs( 2 );

		$_CB_Backend_Title		=	array( 0 => array( 'fa fa-envelope-o', CBTxt::T( 'Community Builder: Mass Mailer' ) ) );

		cbValidator::outputValidatorJs( null );

		$return					=	'<form action="' . $_CB_framework->backendUrl( 'index.php' ) . '" method="post" name="adminForm" class="cb_form form-auto m-0 cbEmailUsersForm">';

		if ( $rows ) {
			$emailsList			=	array();

			foreach ( array_slice( $rows, 0, 100 ) as $row ) {
				$emailsList[]	=	htmlspecialchars( $row->name ) . ' &lt;' . htmlspecialchars( $row->email ) . '&gt;';
			}

			$return				.=		'<div class="form-group row no-gutters cb_form_line">'
								.			'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::Th( 'SEND_EMAIL_TO_TOTAL_USERS', 'Send Email to [total] users', array( '[total]' => (int) count( $rows ) ) ) . '</label>'
								.			'<div class="cb_field col-sm-9">'
								.				'<div class="form-control-plaintext">' . implode( ', ', $emailsList ) . ( count( $rows ) > 100 ? ' <strong>' . CBTxt::Th( 'AND_COUNT_MORE_USERS', 'and [count] more users.', array( '[count]' => (int) ( count( $rows ) - 100 ) ) ) . '</strong>' : null ) . '</div>'
								.			'</div>'
								.		'</div>';
		}

		$return					.=		'<div class="form-group row no-gutters cb_form_line">'
								.			'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::Th( 'MASS_MAILER_SIMULATION_MODE_LABEL', 'Simulation Mode' ) . '</label>'
								.			'<div class="cb_field col-sm-9">'
								.				'<div class="form-control-plaintext">'
								.					'<div class="cbSnglCtrlLbl form-check form-check-inline">'
								.						'<input type="checkbox" name="simulationmode" id="simulationmode" class="form-check-input"' . ( $simulationMode ? ' checked="checked"' : null ) . ' />'
								.						'<label for="simulationmode" class="form-check-label">' . CBTxt::T( 'Do not send emails, just show me how it works' ) . '</label>'
								.					'</div>'
								.					getFieldIcons( 2, false, false, CBTxt::T( 'MASS_MAILER_SIMULATION_MODE_TOOLTIP', 'Check this box to simulate email sending in a dry run mode. No emails are actually sent.' ), CBTxt::T( 'MASS_MAILER_SIMULATION_MODE_LABEL', 'Simulation Mode' ), false, 4 )
								.				'</div>'
								.			'</div>'
								.		'</div>'
								.		'<div class="form-group row no-gutters cb_form_line">'
								.			'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::Th( 'MASS_MAILER_ALSO_TO_LABEL', 'Email Also To' ) . '</label>'
								.			'<div class="cb_field col-sm-9">'
								.				'<div>'
								.					'<input type="text" name="emailto" value="' . htmlspecialchars( $emailTo ) . '" class="form-control required" size="60" />'
								.					getFieldIcons( 2, false, false, CBTxt::T( 'MASS_MAILER_TO_TOOLTIP', 'Optionally input additional email address to send this mailer to. Multiple email addresses can be specified using a comma separator.' ), CBTxt::T( 'MASS_MAILER_ALSO_TO_LABEL', 'Email Also To' ), false, 4 )
								.				'</div>'
								.			'</div>'
								.		'</div>'
								.		'<div class="form-group row no-gutters cb_form_line">'
								.			'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::Th( 'MASS_MAILER_SUBJECT_LABEL', 'Email Subject' ) . '</label>'
								.			'<div class="cb_field col-sm-9">'
								.				'<div>'
								.					'<input type="text" name="emailsubject" value="' . htmlspecialchars( $emailSubject ) . '" class="form-control required" size="60" />'
								.					getFieldIcons( 2, false, false, CBTxt::T( 'MASS_MAILER_SUBJECT_TOOLTIP', 'Type in the subject of the mass mailing (CB field substitutions are supported).' ), CBTxt::T( 'MASS_MAILER_SUBJECT_LABEL', 'Email Subject' ), false, 4 )
								.				'</div>'
								.			'</div>'
								.		'</div>'
								.		'<div class="form-group row no-gutters cb_form_line">'
								.			'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::Th( 'MASS_MAILER_MESSAGE_LABEL', 'Email Message' ) . '</label>'
								.			'<div class="cb_field col-sm-9">'
								.				'<div>'
								.					Application::Cms()->displayCmsEditor( 'emailbody', $emailBody, 600, 200, 50, 7 )
								.					getFieldIcons( 2, false, false, CBTxt::T( 'MASS_MAILER_MESSAGE_TOOLTIP', 'Type in the main message body of your mass mailing (HTML editor and CB field substitutions are supported).' ), CBTxt::T( 'MASS_MAILER_MESSAGE_LABEL', 'Email Message' ), false, 4 )
								.				'</div>'
								.			'</div>'
								.		'</div>'
								.		'<div class="form-group row no-gutters cb_form_line">'
								.			'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::Th( 'MASS_MAILER_ATTACHMENTS_LABEL', 'Email Attachments' ) . '</label>'
								.			'<div class="cb_field col-sm-9">'
								.				'<div>'
								.					'<input type="text" name="emailattach" value="' . htmlspecialchars( $emailAttach ) . '" class="form-control" size="80" />'
								.					getFieldIcons( 2, false, false, CBTxt::T( 'MASS_MAILER_ATTACHMENTS_TOOLTIP', 'Absolute server path to file that should be attached to each email. Multiple files can be specified using a comma separator.' ), CBTxt::T( 'MASS_MAILER_ATTACHMENTS_LABEL', 'Email Attachments' ), false, 4 )
								.				'</div>'
								.			'</div>'
								.		'</div>'
								.		'<div class="form-group row no-gutters cb_form_line">'
								.			'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::Th( 'MASS_MAILER_CC_LABEL', 'Email CC' ) . '</label>'
								.			'<div class="cb_field col-sm-9">'
								.				'<div>'
								.					'<input type="text" name="emailcc" value="' . htmlspecialchars( $emailCC ) . '" class="form-control" size="60" />'
								.					getFieldIcons( 2, false, false, CBTxt::T( 'MASS_MAILER_CC_TOOLTIP', 'Optionally input an email address to CC. Multiple email addresses can be specified using a comma separator. Note this will CC every email sent and can result in multiple emails being received.' ), CBTxt::T( 'MASS_MAILER_CC_LABEL', 'Email CC' ), false, 4 )
								.				'</div>'
								.			'</div>'
								.		'</div>'
								.		'<div class="form-group row no-gutters cb_form_line">'
								.			'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::Th( 'MASS_MAILER_BCC_LABEL', 'Email BCC' ) . '</label>'
								.			'<div class="cb_field col-sm-9">'
								.				'<div>'
								.					'<input type="text" name="emailbcc" value="' . htmlspecialchars( $emailBCC ) . '" class="form-control" size="60" />'
								.					getFieldIcons( 2, false, false, CBTxt::T( 'MASS_MAILER_BCC_TOOLTIP', 'Optionally input an email address to BCC. Multiple email addresses can be specified using a comma separator. Note this will BCC every email sent and can result in multiple emails being received.' ), CBTxt::T( 'MASS_MAILER_BCC_LABEL', 'Email BCC' ), false, 4 )
								.				'</div>'
								.			'</div>'
								.		'</div>'
								.		'<div class="form-group row no-gutters cb_form_line">'
								.			'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::Th( 'Substitutions for Subject, Message, Attachments, CC, and BCC' ) . '</label>'
								.			'<div class="cb_field col-sm-9">'
								.				'<div class="form-control-plaintext">' . CBTxt::T( 'You can use all CB substitutions as in most parts: e.g.: [cb:if team="winners"] Congratulations [cb:userfield field="name" /], you are in the winning team! [/cb:if]' ) . '</div>'
								.			'</div>'
								.		'</div>'
								.		$this->_pluginRows( $pluginRows )
								.		'<div class="form-group row no-gutters cb_form_line">'
								.			'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::Th( 'MASS_MAILER_FROM_NAME_LABEL', 'From Name' ) . '</label>'
								.			'<div class="cb_field col-sm-9">'
								.				'<div>'
								.					'<input type="text" name="emailfromname" value="' . htmlspecialchars( $emailFromName ) . '" class="form-control" size="30" />'
								.					getFieldIcons( 2, false, false, CBTxt::T( 'MASS_MAILER_FROM_NAME_TOOLTIP', 'The name to be used in the From field of email. If left empty the CB and Joomla configuration defaults will be used.' ), CBTxt::T( 'MASS_MAILER_FROM_NAME_LABEL', 'From Name' ), false, 4 )
								.				'</div>'
								.			'</div>'
								.		'</div>'
								.		'<div class="form-group row no-gutters cb_form_line">'
								.			'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::Th( 'MASS_MAILER_FROM_ADDRESS_LABEL', 'From Email Address' ) . '</label>'
								.			'<div class="cb_field col-sm-9">'
								.				'<div>'
								.					'<input type="text" name="emailfromaddr" value="' . htmlspecialchars( $emailFromAddr ) . '" class="form-control" size="40" />'
								.					getFieldIcons( 2, false, false, CBTxt::T( 'MASS_MAILER_FROM_ADDRESS_TOOLTIP', 'The email address to be user in the From field of email. If left empty the CB and Joomla settings will be used.' ), CBTxt::T( 'MASS_MAILER_FROM_ADDRESS_LABEL', 'From Email Address' ), false, 4 )
								.				'</div>'
								.			'</div>'
								.		'</div>'
								.		'<div class="form-group row no-gutters cb_form_line">'
								.			'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::Th( 'MASS_MAILER_REPLY_TO_NAME_LABEL', 'Reply-To Name' ) . '</label>'
								.			'<div class="cb_field col-sm-9">'
								.				'<div>'
								.					'<input type="text" name="emailreplyname" value="' . htmlspecialchars( $emailReplyName ) . '" class="form-control" size="30" />'
								.					getFieldIcons( 2, false, false, CBTxt::T( 'MASS_MAILER_REPLY_TO_NAME_TOOLTIP', 'The Reply-To Name value to be used in the From field of email. If left empty the CB and Joomla settings will be used.' ), CBTxt::T( 'MASS_MAILER_REPLY_TO_NAME_LABEL', 'Reply-To Name' ), false, 4 )
								.				'</div>'
								.			'</div>'
								.		'</div>'
								.		'<div class="form-group row no-gutters cb_form_line">'
								.			'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::Th( 'MASS_MAILER_REPLY_TO_ADDRESS_LABEL', 'Reply-To Email Address' ) . '</label>'
								.			'<div class="cb_field col-sm-9">'
								.				'<div>'
								.					'<input type="text" name="emailreplyaddr" value="' . htmlspecialchars( $emailReplyAddr ) . '" class="form-control" size="40" />'
								.					getFieldIcons( 2, false, false, CBTxt::T( 'MASS_MAILER_REPLY_TO_ADDRESS_TOOLTIP', 'The Reply-To Email address to be used in the email.' ), CBTxt::T( 'MASS_MAILER_REPLY_TO_ADDRESS_LABEL', 'Reply-To Email Address' ), false, 4 )
								.				'</div>'
								.			'</div>'
								.		'</div>'
								.		'<div class="form-group row no-gutters cb_form_line">'
								.			'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::Th( 'MASS_MAILER_EMAILS_PER_BATCH_LABEL', 'Emails per batch' ) . '</label>'
								.			'<div class="cb_field col-sm-9">'
								.				'<div>'
								.					'<input type="text" name="emailsperbatch" value="' . htmlspecialchars( $emailsPerBatch ) . '" class="form-control required digits" size="12" />'
								.					getFieldIcons( 2, false, false, CBTxt::T( 'MASS_MAILER_EMAILS_PER_BATCH_TOOLTIP', 'The number of emails to be sent in each batch (default 50).' ), CBTxt::T( 'MASS_MAILER_EMAILS_PER_BATCH_LABEL', 'Emails per batch' ), false, 4 )
								.				'</div>'
								.			'</div>'
								.		'</div>'
								.		'<div class="form-group row no-gutters cb_form_line">'
								.			'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::Th( 'MASS_MAILER_SECONDS_BETWEEN_BATCHES_LABEL', 'Seconds of pause between batches' ) . '</label>'
								.			'<div class="cb_field col-sm-9">'
								.				'<div>'
								.					'<input type="text" name="emailpause" value="' . htmlspecialchars( $emailPause ) . '" class="form-control required digits" size="12" />'
								.					getFieldIcons( 2, false, false, CBTxt::T( 'MASS_MAILER_SECONDS_BETWEEN_BATCHES_TOOLTIP', 'The number of seconds to pause between batch sending (default is 30 sec).' ), CBTxt::T( 'MASS_MAILER_SECONDS_BETWEEN_BATCHES_LABEL', 'Seconds of pause between batches' ), false, 4 )
								.				'</div>'
								.			'</div>'
								.		'</div>'
								.		'<input type="hidden" name="option" value="com_comprofiler" />'
								.		'<input type="hidden" name="view" value="emailusers" />'
								.		'<input type="hidden" name="boxchecked" value="0" />';

		foreach ( $rows as $row ) {
			if ( ! $row->id ) {
				continue;
			}

			$return				.=		'<input type="hidden" name="cid[]" value="' . (int) $row->id . '">';
		}

		$return					.=		Application::Session()->getFormTokenInput()
								.	'</form>';

		echo $return;
	}

	/**
	 * Sends legacy mass mailer
	 *
	 * @deprecated 2.0
	 *
	 * @param  UserTable[]  $rows
	 * @param  string       $emailTo
	 * @param  string       $emailSubject
	 * @param  string       $emailBody
	 * @param  string       $emailAttach
	 * @param  string       $emailFromName
	 * @param  string       $emailCC
	 * @param  string       $emailBCC
	 * @param  string       $emailFromAddr
	 * @param  string       $emailReplyName
	 * @param  string       $emailReplyAddr
	 * @param  int          $emailsPerBatch
	 * @param  int          $emailsBatch
	 * @param  int          $emailPause
	 * @param  bool         $simulationMode
	 * @param  array        $pluginRows
	 * @return void
	 */
	public function startEmailUsers( $rows, $emailTo, $emailSubject, $emailBody, $emailAttach, $emailCC, $emailBCC, $emailFromName, $emailFromAddr, $emailReplyName, $emailReplyAddr, $emailsPerBatch, $emailsBatch, $emailPause, $simulationMode, $pluginRows ) {
		global $_CB_framework, $_CB_Backend_Title;

		_CBsecureAboveForm( 'showUsers' );

		outputCbTemplate( 2 );
		outputCbJs( 2 );

		$_CB_Backend_Title			=	array( 0 => array( 'fa fa-envelope-o', CBTxt::T( 'Community Builder: Sending Mass Mailer' ) ) );

		$userIds					=	array();

		foreach ( $rows as $row ) {
			$userIds[]				=	(int) $row->id;
		}

		$maximumBatches				=	( count( $rows ) / $emailsPerBatch );

		if ( $maximumBatches < 1 ) {
			$maximumBatches			=	1;
		}

		$progressPerBatch			=	round( 100 / $maximumBatches );
		$delayInMilliseconds		=	( $emailPause ? ( $emailPause * 1000 ) : 0 );

		$js							=	"var cbbatchemail = function( batch, emailsbatch, emailsperbatch ) {"
									.		"$.ajax({"
									.			"type: 'POST',"
									.			"url: '" . addslashes( $_CB_framework->backendViewUrl( 'ajaxemailusers', false, array(), 'raw' ) ) . "',"
									.			"dataType: 'json',"
									.			"headers: {"
									.				"'X-CSRF-Token': " . json_encode( Application::Session()->getFormTokenName() )
									.			"},"
									.			"data: {"
									.				"emailto: '" . addslashes( $emailTo ) . "',"
									.				"emailsubject: " . json_encode( $emailSubject ) . ","
									.				"emailbody: " . json_encode( $emailBody ) . ","
									.				"emailattach: '" . addslashes( $emailAttach ) . "',"
									.				"emailcc: '" . addslashes( $emailCC ) . "',"
									.				"emailbcc: '" . addslashes( $emailBCC ) . "',"
									.				"emailfromname: '" . addslashes( $emailFromName ) . "',"
									.				"emailfromaddr: '" . addslashes( $emailFromAddr ) . "',"
									.				"emailreplyname: '" . addslashes( $emailReplyName ) . "',"
									.				"emailreplyaddr: '" . addslashes( $emailReplyAddr ) . "',"
									.				"emailsperbatch: emailsperbatch,"
									.				"emailsbatch: emailsbatch,"
									.				"emailpause: '" . addslashes( $emailPause ) . "',"
									.				"simulationmode: '" . addslashes( $simulationMode ) . "',"
									.				"cid: " . json_encode( $userIds )
									.			"},"
									.			"success: function( data, textStatus, jqXHR ) {"
									.				"if ( data.result == 1 ) {" // Success (Loop)
									.					"var progress = ( " . (int) $progressPerBatch . " * batch ) + '%';"
									.					"$( '#cbProgressIndicatorBar > .progress-bar' ).css({ width: progress });"
									.					"$( '#cbProgressIndicatorBar > .progress-bar > span' ).html( progress );"
									.					"$( '#cbProgressIndicator' ).html( data.htmlcontent );"
									.					"setTimeout( function() {"
									.						"cbbatchemail( ( batch + 1 ), ( emailsbatch + emailsperbatch ), emailsperbatch );"
									.					"}, " . (int) $delayInMilliseconds . " );"
									.				"} else if ( data.result == 2 ) {" // Success (Done)
									.					"$( '#cbProgressIndicatorBar' ).removeClass( 'progress-striped progress-bar-animated' );"
									.					"$( '#cbProgressIndicatorBar > .progress-bar' ).css({ width: '100%' });"
									.					"$( '#cbProgressIndicatorBar > .progress-bar' ).addClass( 'bg-success' );"
									.					"$( '#cbProgressIndicatorBar > .progress-bar > span' ).html( '100%' );"
									.					"$( '#cbProgressIndicator' ).html( data.htmlcontent );"
									.				"} else {" // Failed
									.					"$( '#cbProgressIndicatorBar' ).removeClass( 'progress-striped progress-bar-animated' );"
									.					"$( '#cbProgressIndicatorBar > .progress-bar' ).css({ width: '100%' });"
									.					"$( '#cbProgressIndicatorBar > .progress-bar' ).addClass( 'bg-danger' );"
									.					"$( '#cbProgressIndicatorBar > .progress-bar > span' ).html( '" . addslashes( CBTxt::T( 'Email failed to send' ) ) . "' );"
									.					"$( '#cbProgressIndicator' ).html( data.htmlcontent );"
									.				"}"
									.			"},"
									.			"error: function( jqXHR, textStatus, errorThrown ) {"
									.				"$( '#cbProgressIndicatorBar' ).removeClass( 'progress-striped progress-bar-animated' );"
									.				"$( '#cbProgressIndicatorBar > .progress-bar' ).css({ width: '100%' });"
									.				"$( '#cbProgressIndicatorBar > .progress-bar' ).addClass( 'bg-danger' );"
									.				"$( '#cbProgressIndicatorBar > .progress-bar > span' ).html( '" . addslashes( CBTxt::T( 'Email failed to send' ) ) . "' );"
									.				"$( '#cbProgressIndicator' ).html( errorThrown );"
									.			"}"
									.		"});"
									.	"};"
									.	"cbbatchemail( 1, " . (int) $emailsBatch . ", " . (int) $emailsPerBatch . " );";

		$_CB_framework->outputCbJQuery( $js );

		$return						=	'<form action="' . $_CB_framework->backendUrl( 'index.php' ) . '" method="post" id="cbmailbatchform" name="adminForm" class="cb_form form-auto m-0 cbEmailUsersBatchForm">';

		if ( $simulationMode ) {
			$return					.=		'<div class="form-group row no-gutters cb_form_line">'
									.			'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'MASS_MAILER_SIMULATION_MODE_LABEL', 'Simulation Mode' ) . '</label>'
									.			'<div class="cb_field col-sm-9">'
									.				'<div class="form-control-plaintext">'
									.					'<div class="cbSnglCtrlLbl form-check form-check-inline">'
									.						'<input type="checkbox" name="simulationmode" id="simulationmode" class="form-check-input" checked="checked" disabled="disabled" />'
									.						'<label for="simulationmode" class="form-check-label">' . CBTxt::T( 'Do not send emails, just show me how it works' ) . '</label>'
									.					'</div>'
									.				'</div>'
									.			'</div>'
									.		'</div>';
		}

		$return						.=		$this->_pluginRows( $pluginRows )
									.		'<div class="form-group row no-gutters cb_form_line">'
									.			'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'SEND_EMAIL_TO_TOTAL_USERS', 'Send Email to [total] users', array( '[total]' => (int) count( $rows ) ) ) . '</label>'
									.			'<div class="cb_field col-sm-9">'
									.				'<div class="form-control-plaintext">'
									.					'<div id="cbProgressIndicatorBar" class="progress progress-striped progress-bar-animated">'
									.						'<div class="progress-bar" style="width: 0;">'
									.							'<span></span>'
									.						'</div>'
									.					'</div>'
									.					'<div id="cbProgressIndicator"></div>'
									.				'</div>'
									.			'</div>'
									.		'</div>'
									.		$this->_pluginRows( $pluginRows );

		if ( ! $simulationMode ) {
			$return					.=		'<input type="hidden" name="simulationmode" value="' . htmlspecialchars( $simulationMode ) . '" />';
		}

		$return						.=		'<input type="hidden" name="option" value="com_comprofiler" />'
									.		'<input type="hidden" name="view" value="ajaxemailusers" />'
									.		'<input type="hidden" name="boxchecked" value="0" />';

		foreach ( $rows as $row ) {
			if ( ! $row->id ) {
				continue;
			}

			$return					.=		'<input type="hidden" name="cid[]" value="' . (int) $row->id . '">';
		}

		$return						.=		Application::Session()->getFormTokenInput()
									.	'</form>';

		echo $return;
	}

	/**
	 * Outputs legacy ajax results of mass mailer
	 *
	 * @param string  $usernames
	 * @param string  $emailSubject
	 * @param string  $emailBody
	 * @param string  $emailAttach
	 * @param string  $emailCC
	 * @param string  $emailBCC
	 * @param string  $emailFromName
	 * @param string  $emailFromAddr
	 * @param string  $emailReplyName
	 * @param string  $emailReplyAddr
	 * @param int     $limitstart
	 * @param int     $limit
	 * @param int     $total
	 * @param string  $errors
	 * @deprecated 2.0
	 */
	public function ajaxResults( $usernames, $emailSubject, $emailBody, $emailAttach, $emailCC, $emailBCC, $emailFromName, $emailFromAddr, $emailReplyName, $emailReplyAddr, $limitstart, $limit, $total, $errors ) {
		global $_CB_framework;

		$return				=	null;

		if ( $errors == 0 ) {
			$return			.=	'<div class="mb-3 border-bottom cb-page-header">'
							.		'<h3 class="m-0 p-0 mb-2 cb-page-header-title">' . CBTxt::T( 'SENT_EMAIL_TO_COUNT_OF_TOTAL_USERS', 'Sent email to [count] of [total] users', array( '[count]' => min( $total, $limitstart + $limit ), '[total]' => $total ) ) . '</h3>'
							.	'</div>'
							.	CBTxt::T( 'JUST_SENT_COUNT_EMAILS_TO_FOLLOWING_USERS_USERNAMES', 'Just sent [count] emails to following users: [usernames]', array( '[count]' => min( $limit, $total - $limitstart ), '[usernames]' => $usernames ) );
		} else {
			$return			.=	'<div class="mb-3 border-bottom cb-page-header">'
							.		'<h3 class="m-0 p-0 mb-2 cb-page-header-title">' . CBTxt::T( 'COULD_NOT_EMAIL_TO_ERRORS_OF_COUNT_USERS_OUT_OF_TOTAL_EMAILS_TO_SEND', 'Could not send email to [errors] of [count] users out of [total] emails to send', array( '[count]' => min( $total, $limitstart + $limit ), '[total]' => $total, '[errors]' => $errors ) ) . '</h3>'
							.	'</div>'
							.	CBTxt::T( 'JUST_SENT_COUNT_EMAILS_TO_FOLLOWING_USERS_USERNAMES', 'Just sent [count] emails to following users: [usernames]', array( '[count]' => ( min( $limit, $total - $limitstart ) - $errors ), '[usernames]' => $usernames ) );
		}

		if ( ( $total - ( $limitstart + $limit ) ) > 0 ) {
			$return			.=	'<div class="mb-3 border-bottom cb-page-header">'
							.		'<h3 class="m-0 p-0 mb-2 cb-page-header-title">' . CBTxt::T( 'STILL_COUNT_EMAILS_REMAINING_TO_SEND', 'Still [count] emails remaining to send', array( '[count]' => ( $total - ( $limitstart + $limit ) ) ) ) . '</h3>'
							.	'</div>';
		} else {
			if ( $errors > 0 ) {
				$return		.=	'<div class="mb-3 border-bottom cb-page-header">'
							.		'<h3 class="m-0 p-0 mb-2 cb-page-header-title">' . CBTxt::T( 'ERRORS_EMAILS_COULD_NOT_BE_SENT_DUE_TO_A_SENDING_ERROR', '[errors] emails could not be sent due to a sending error', array( '[errors]' => $errors ) ) . '</h3>'
							.	'</div>';
			} elseif ( $total == 1 ) {
				$return		.=	'<div class="mb-3 border-bottom cb-page-header">'
							.		'<h3 class="m-0 p-0 mb-2 cb-page-header-title">' . CBTxt::T( 'Your email has been sent' ) . '</h3>'
							.	'</div>';
			} else {
				$return		.=	'<div class="mb-3 border-bottom cb-page-header">'
							.		'<h3 class="m-0 p-0 mb-2 cb-page-header-title">' . CBTxt::T( 'ALL_TOTAL_EMAILS_HAVE_BEEN_SENT', 'All [total] emails have been sent', array( '[total]' => $total ) ) . '</h3>'
							.	'</div>';
			}
		}

		if ( ! ( $total - ( $limitstart + $limit ) > 0 ) ) {
			$return			.=	'<div class="form-group row no-gutters cb_form_line">'
							.		'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Email Subject' ) . '</label>'
							.		'<div class="cb_field col-sm-9">'
							.			'<div>' . htmlspecialchars( $emailSubject ) . '</div>'
							.		'</div>'
							.	'</div>'
							.	'<div class="form-group row no-gutters cb_form_line">'
							.		'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Email Message' ) . '</label>'
							.		'<div class="cb_field col-sm-9">'
							.			'<div>' . htmlspecialchars( $emailBody ) . '</div>'
							.		'</div>'
							.	'</div>'
							.	'<div class="form-group row no-gutters cb_form_line">'
							.		'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Email Attachments' ) . '</label>'
							.		'<div class="cb_field col-sm-9">'
							.			'<div>' . htmlspecialchars( $emailAttach ) . '</div>'
							.		'</div>'
							.	'</div>'
							.	'<div class="form-group row no-gutters cb_form_line">'
							.		'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'CC' ) . '</label>'
							.		'<div class="cb_field col-sm-9">'
							.			'<div>' . htmlspecialchars( $emailCC ) . '</div>'
							.		'</div>'
							.	'</div>'
							.	'<div class="form-group row no-gutters cb_form_line">'
							.		'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'BCC' ) . '</label>'
							.		'<div class="cb_field col-sm-9">'
							.			'<div>' . htmlspecialchars( $emailBCC ) . '</div>'
							.		'</div>'
							.	'</div>'
							.	'<div class="form-group row no-gutters cb_form_line">'
							.		'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'From Name' ) . '</label>'
							.		'<div class="cb_field col-sm-9">'
							.			'<div>' . htmlspecialchars( $emailFromName ) . '</div>'
							.		'</div>'
							.	'</div>'
							.	'<div class="form-group row no-gutters cb_form_line">'
							.		'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'From Email Address' ) . '</label>'
							.		'<div class="cb_field col-sm-9">'
							.			'<div>' . htmlspecialchars( $emailFromAddr ) . '</div>'
							.		'</div>'
							.	'</div>'
							.	'<div class="form-group row no-gutters cb_form_line">'
							.		'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Reply-To Name' ) . '</label>'
							.		'<div class="cb_field col-sm-9">'
							.			'<div>' . htmlspecialchars( $emailReplyName ) . '</div>'
							.		'</div>'
							.	'</div>'
							.	'<div class="form-group row no-gutters cb_form_line">'
							.		'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Reply-To Email Address' ) . '</label>'
							.		'<div class="cb_field col-sm-9">'
							.			'<div>' . htmlspecialchars( $emailReplyAddr ) . '</div>'
							.		'</div>'
							.	'</div>'
							.	'<h3><a href="' . $_CB_framework->backendViewUrl( 'showusers' ) . '">' . CBTxt::T( 'Click here to go back to User Management' ) . '</a></h3>';
		}

		echo $return;
	}
}